"use strict";
// Class definition

var KTDatatableHtmlTableDemo = function() {
	// Private functions

	// demo initializer
	var demo = function() {

		var datatable = $('.kt-datatable').KTDatatable({
			data: {
				saveState: {cookie: false},
			},
			search: {
				input: $('#generalSearch'),
			},
			columns: [
				{
					field: 'Account From',
					type: 'Account From',
					width:150,
				},
				{
					field: 'Account To',
					type: 'Supplier To',
					width:150,
				},
                
				{
					field: 'Date',
					type: 'Date',
					width:100,
				},
				{
					field: 'Account From Currency Amount',
					type: 'Account From Currency Amount',
					width:220,
				},
				{
					field: 'Account To Currency Amount',
					type: 'Account To Currency Amount',
					width:220,
				},
				
			],

		});

    $('#kt_form_status').on('change', function() {
      datatable.search($(this).val().toLowerCase(), 'Status');
    });

    $('#kt_form_status').selectpicker();

	};

	return {
		// Public functions
		init: function() {
			// init dmeo
			demo();
		},
	};
}();

jQuery(document).ready(function() {
	KTDatatableHtmlTableDemo.init();
});