<?php 
include('../include/security.php');
include('../include/conn.php');
?>
<!DOCTYPE html>
<html lang="en" >
<head>
        <meta charset="utf-8"/>

        <title><?php echo $title;?> - Payments</title>
        <meta name="description" content="Deposit">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <!--begin::Fonts -->
        <link rel="stylesheet" href="assets/css/bear/fonts.css?family=Poppins:300,400,500,600,700|Roboto:300,400,500,600,700">       <!--end::Fonts -->

        
        
        <!--begin::Global Theme Styles(used by all pages) -->
                    <link href="assets/vendors/global/vendors.bundle.css" rel="stylesheet" type="text/css" />
                    <link href="assets/css/bear/style.bundle.css" rel="stylesheet" type="text/css" />
                <!--end::Global Theme Styles -->

        <!--begin::Layout Skins(used by all pages) -->
                <!--end::Layout Skins -->

        <link rel="shortcut icon" href="assets/media/logos/favicon.png" />

    </head>
    <!-- end::Head -->

    <!-- begin::Body -->
    <body  class="kt-app__aside--left kt-quick-panel--right kt-demo-panel--right kt-offcanvas-panel--right kt-header--fixed kt-header-mobile--fixed kt-subheader--enabled kt-subheader--transparent kt-aside--enabled kt-aside--fixed kt-aside--minimize kt-page--loading"  >

       
    	<!-- begin:: Page -->
	
<!-- begin:: Header Mobile -->
<?php include("../include/header-mobile.php");?>	
<!-- end:: Header Mobile -->
	<div class="kt-grid kt-grid--hor kt-grid--root">
		<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--ver kt-page">
			<!-- begin:: Aside -->
<button class="kt-aside-close " id="kt_aside_close_btn"><i class="la la-close"></i></button>

<?php include("../include/leftside-menu.php");?>	
<div class="kt-aside-menu-overlay"></div>
<!-- end:: Aside --></div>

<div class="kt-aside-menu-overlay"></div>
<!-- end:: Aside -->
			<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor kt-wrapper" id="kt_wrapper">
<!-- begin:: Header -->
<div id="kt_header" class="kt-header kt-grid kt-grid--ver  kt-header--fixed " >
			<!-- begin: Header Menu -->
<button class="kt-header-menu-wrapper-close" id="kt_header_menu_mobile_close_btn"><i class="la la-close"></i></button>
<?php include("../include/header-top-menu.php");?>	
<!-- end: Header Menu -->	
	<!-- begin:: Header Topbar -->
<div class="kt-header__topbar">


	<!--begin: Notifications -->
	<?php include("../include/header-notifications.php");?>	
	<!--end: Notifications -->

	<!--begin: Quick actions -->
    <?php include("../include/header-top-right-quick-btn.php");?>
	<!--end: Quick actions -->



	<!--begin: User bar -->
	<?php include("../include/header-top-right.php");?>
	<!--end: User bar -->


</div>
<!-- end:: Header Topbar -->
</div>
<!-- end:: Header -->
				<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">
											
<!-- begin:: Subheader -->
<div class="kt-subheader   kt-grid__item" id="kt_subheader">
    <div class="kt-container  kt-container--fluid ">
        <div class="kt-subheader__main">
            <h3 class="kt-subheader__title">
					                <button class="kt-subheader__mobile-toggle kt-subheader__mobile-toggle--left" id="kt_subheader_mobile_toggle"><span></span></button>
	            
                Payments                          </h3>

                            <span class="kt-subheader__separator kt-hidden"></span>
                <div class="kt-subheader__breadcrumbs">
  

                                            <span class="kt-subheader__breadcrumbs-separator"></span>
                        <a href="javascript:" class="kt-subheader__breadcrumbs-link">
                            Add Payment                        </a>
                                        <!-- <span class="kt-subheader__breadcrumbs-link kt-subheader__breadcrumbs-link--active">Active link</span> -->
                </div>
                    </div>
      
	  
	
	</div>
</div>
<!-- end:: Subheader -->
					
					<!-- begin:: Content -->
	<div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">
		<!--Begin::App-->
<div class="kt-grid kt-grid--desktop kt-grid--ver kt-grid--ver-desktop kt-app">
    <!--Begin:: App Aside Mobile Toggle-->
    <button class="kt-app__aside-close" id="kt_user_profile_aside_close">
        <i class="la la-close"></i>
    </button>
    <!--End:: App Aside Mobile Toggle-->

    <!--Begin:: App Aside-->
    <div class="kt-grid__item kt-app__toggle kt-app__aside" id="kt_user_profile_aside">
        <!--begin:: Widgets/Applications/User/Profile1-->
<div class="kt-portlet kt-portlet--height-fluid-">
    <div class="kt-portlet__head  kt-portlet__head--noborder">
        <div class="kt-portlet__head-label">
            <h3 class="kt-portlet__head-title">
            </h3>
        </div>
   
    </div>
    <div class="kt-portlet__body kt-portlet__body--fit-y">
        <!--begin::Widget -->
        <div class="kt-widget kt-widget--user-profile-1">
     
            <div class="kt-widget__body">
               <form class="kt-form" id="kt_form" action="../controllers/payments.php?insert=<?php echo base64_encode('payment');?>" method="POST" enctype="multipart/form-data">               
			   <div class="kt-widget__content">
					<div class="row">		
					 <div class="col-lg-12"> 								
						<div class="form-group">
							<label>Supplier</label>
							 <select id="payment_supplier_id" name="payment_supplier_id" class="form-control" required onchange="get_currency();">
								<option value="">Select</option>
								<?php 
								   $suppliers= mysqli_query($db,"SELECT * FROM tblsuppliers where supplier_status='Active' order by supplier_first_name asc");
								   while($supplier = mysqli_fetch_array($suppliers)){   
								?>
								<option value="<?php echo $supplier['supplier_id'];?>"><?php echo $supplier['supplier_first_name'];?> <?php echo $supplier['supplier_last_name'];?> - <?php echo $supplier['supplier_currency'];?></option>
								
								<?php } ?>
							</select>
							<!--<span class="form-text text-muted"><a href="../suppliers/add-supplier.php?url=add-payment.php">Add New Supplier</a></span>-->
						</div>
					 </div>	
					 <div class="col-lg-12"> 								
						<div class="form-group">
							<label>Account</label>
							 <select id="payment_account_id" name="payment_account_id" class="form-control" required onchange="get_currency();">
								<option value="">Select</option>
								<?php 
								   $accounts= mysqli_query($db,"SELECT * FROM tblaccounts where account_status='Active' order by account_name asc");
								   while($account = mysqli_fetch_array($accounts)){   
								?>
								<option value="<?php echo $account['account_id'];?>"><?php echo $account['account_name'];?> - <?php echo $account['account_currency'];?></option>
								
								<?php } ?>
							</select>
							<!--<span class="form-text text-muted"><a href="#">Add New Account</a></span>-->
						</div>
					 </div>	
					  <div class="col-lg-12"> 								
						<div class="form-group">
							<label>Orders</label>
							 <select id="payment_order_id" name="payment_order_id" class="form-control" required>
								<option value="">Select</option>
								<?php 
								   $orders= mysqli_query($db,"SELECT * FROM tblorders order by order_title asc");
								   while($order = mysqli_fetch_array($orders)){   
								?>
								<option value="<?php echo $order['order_id'];?>"><?php echo $order['order_title'];?></option>
								
								<?php } ?>
							</select>
						</div>
					 </div>	
					 <div class="col-lg-12"> 								
						<div class="form-group">
							<label>Date</label>
							<input type="text" class="form-control" id="payment_date" name="payment_date" required>
							<span class="form-text text-muted">Please enter your payment date.</span>
						</div>
					 </div>	
					   <div class="col-lg-12"> 								
						<div class="form-group">
							<label>Description</label>
							<textarea class="form-control"  id="payment_description" name="payment_description"></textarea>
							<span class="form-text text-muted">Please enter your payment description.</span>
						</div>
					 </div>	
		              <div id="html_currency"></div>
					 <div class="col-lg-12" id="c_rate"> 								
						<label style="font-size: 1rem;font-weight: 400;">Conversion Rate</label>
						<div class="input-group">
						
                            <div class="input-group-prepend"><span class="input-group-text" id="currency_rate_sign">USD</span></div>
                            <input type="text" class="form-control" id="payment_conv_rate" name="payment_conv_rate">
							<span class="form-text text-muted" style="margin-bottom:20px;">Please enter your payment conversion rate.</span>
                        </div>
					 </div>	
					 
					 
					  <div class="col-lg-12"> 								
						<label style="font-size: 1rem;font-weight: 400;">Amount</label>
						<div class="input-group">
						    
                            <div class="input-group-prepend"><span class="input-group-text" id="currency_sign">USD</span></div>
                            <input type="text" class="form-control" id="payment_amount" name="payment_amount" required>
							<span class="form-text text-muted" style="margin-bottom:20px;">Please enter your payment amount.&nbsp;&nbsp;&nbsp;&nbsp;</span>
                        </div>
					 </div>	
					 
					  <div class="col-lg-12"> 								
						<div class="form-group">
							<label>Ref #</label>
							<input type="text" class="form-control" id="payment_ref_no" name="payment_ref_no" >
							<span class="form-text text-muted">Please enter refernce no.</span>
						</div>
					 </div>	
					
					 
					  <div class="col-lg-12" style="display:none;"> 								
						<div class="form-group">
							<label>Notify By</label>
							  <div class="kt-checkbox-inline">
                                                        <label class="kt-checkbox">
                                                            <input type="radio"  id="payment_notify_by1" name="payment_notify_by" value="Email"> Email
                                                            <span></span>
                                                        </label>
                                                        <label class="kt-checkbox">
                                                            <input type="radio"  id="payment_notify_by2" name="payment_notify_by" value="SMS"> SMS
                                                            <span></span>
                                                        </label>
                                                        <label class="kt-checkbox">
                                                            <input type="radio" id="payment_notify_by3" name="payment_notify_by" value="Phone"> Phone
                                                            <span></span>
                                                        </label>
                                                    </div>
						</div>
					 </div>	
					 
					 <div class="col-lg-12"> 								
						<div class="form-group">
							<button class="btn btn-success btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u" data-ktwizard-type="action-submit">
							Submit
						</button>
						</div>
					 </div>	
					 
					</div>
                </div>
               </form>
			 
		   </div>
        </div>
        <!--end::Widget -->
    </div>

	
	
	</div>
<!--end:: Widgets/Applications/User/Profile1-->

     </div>
    <!--End:: App Aside-->

    <!--Begin:: App Content-->
    <div class="kt-grid__item kt-grid__item--fluid kt-app__content">
        <div class="row">
            <div class="col-xl-12">
                <!--begin:: Widgets/Order Statistics-->
<div class="kt-portlet kt-portlet--height-fluid">
	<div class="kt-portlet__head">
		<div class="kt-portlet__head-label">
			<h3 class="kt-portlet__head-title">
				Recent Payments
			</h3>
		</div>
		<div class="kt-portlet__head-toolbar">
  
		</div>
	</div>
	<div class="kt-portlet__body kt-portlet__body--fluid">
		<div class="kt-widget12">
			<div class="kt-widget12__content">
            		<!--begin: Datatable -->
		<table class="kt-datatable" id="html_table" width="100%">
			<thead>
			<tr>
			    <th>Account</th>
				<th>Supplier</th>
                <th>Order Title</th>
				<th>Date</th>
                <th>Conversion Rate</th>
				<th>Supplier Currency Amount</th>
				<th>Account Currency Amount</th>
				<th>Description</th>
				<th>Ref # </th>
				<th>Notify By</th>
                <th>Action</th>

			</tr>
			</thead>
			<tbody>
			<?php 
			   $payments= mysqli_query($db,"SELECT * FROM tblpayments order by payment_id desc limit 0,50");
			   while($payment = mysqli_fetch_array($payments)){  

               	     $accounts= mysqli_query($db,"SELECT account_name,account_currency FROM tblaccounts where account_id = '".$payment['payment_account_id']."'");
                     $account = mysqli_fetch_array($accounts);		
                     
					 $suppliers= mysqli_query($db,"SELECT supplier_first_name,supplier_last_name,supplier_currency FROM tblsuppliers where supplier_id = '".$payment['payment_supplier_id']."'");
					 $supplier = mysqli_fetch_array($suppliers); 

					 $orders= mysqli_query($db,"SELECT order_title FROM tblorders where order_id = '".$payment['payment_order_id']."'");
					 $order = mysqli_fetch_array($orders); 			
					 

						$payment_amount = $payment['payment_amount'] * $payment['payment_conv_rate'];			
                        $amount_in_ac   = number_format($payment['payment_amount']);						 
		    ?>
			<tr>
                <td><?php echo $account['account_name'];?></td>
                <td><a href="../suppliers/overview.php?id=<?php echo $payment['payment_supplier_id'];?>" target="_blank"><?php echo $supplier['supplier_first_name'];?> <?php echo $supplier['supplier_last_name'];?></a></td>
                <td><?php echo $order['order_title'];?></td>
                <td><?php echo date("d-M-y", strtotime($payment['payment_date']));?></td>
				
				<td><?php echo $payment['payment_conv_rate'];?></td>
				<td><?php echo $supplier['supplier_currency'];?> <?php if($payment['payment_amount']==""){echo "0.00";}else{ echo number_format($payment_amount);}?></td>
				<td><?php echo $account['account_currency'];?> <?php echo $amount_in_ac;?></td>
				<td><?php echo $payment['payment_description'];?></td>
				<td><?php echo $payment['payment_ref_no'];?></td>
				<td><?php echo $payment['payment_notify_by'];?></td> 
				
				<td>
						<a href="javascript:;" class="btn btn-sm btn-clean btn-icon btn-icon-md" title="Delete" onclick="window.location='../controllers/payments.php?delete=<?php echo base64_encode('payment');?>&id=<?php echo base64_encode($payment['payment_id']);?>';">
							<i class="la la-trash"></i></a>
				</td>
			</tr>
			
			<?php } ?>	
			
			</tbody>
		
		
		
		</table>
		<!--end: Datatable -->    
			</div>
			
		</div>	
            <div class="kt-widget12__chart" style="height:863px;">
				
			</div>		
	</div>
</div>
<!--end:: Widgets/Order Statistics-->            </div>
 
        </div>   
      
	  
	
	</div>
    <!--End:: App Content-->
</div>
<!--End::App-->
	</div>
<!-- end:: Content -->				</div>	
				
				<!-- begin:: Footer -->
<?php include("../include/footer.php");?>
<!-- end:: Footer -->			</div>
		</div>
	</div>
	
<!-- end:: Page -->

<?php include("../include/footer-quick-modal.php");?>
    
    <!-- begin::Scrolltop -->
<div id="kt_scrolltop" class="kt-scrolltop">
		<i class="fa fa-arrow-up"></i>
</div>
<!-- end::Scrolltop -->




						 </div>
                        </div>
                    </div>
             
                </div>
            </div>
        </div>
    </div>
</div>
<?php $temp=base64_encode('get-currency');?>
<!--ENd:: Chat-->
        <!-- begin::Global Config(global config for global JS sciprts) -->
        <script>
            var KTAppOptions = {"colors":{"state":{"brand":"#22b9ff","light":"#ffffff","dark":"#282a3c","primary":"#5867dd","success":"#34bfa3","info":"#36a3f7","warning":"#ffb822","danger":"#fd3995"},"base":{"label":["#c5cbe3","#a1a8c3","#3d4465","#3e4466"],"shape":["#f0f3ff","#d9dffa","#afb4d4","#646c9a"]}}};
        </script>
        <!-- end::Global Config -->

    	<!--begin::Global Theme Bundle(used by all pages) -->
    	    	   <script src="assets/vendors/global/vendors.bundle.js" type="text/javascript"></script>
		    	   <script src="assets/js/bear/scripts.bundle.js" type="text/javascript"></script>
				<!--end::Global Theme Bundle -->

        
                    <!--begin::Page Scripts(used by this page) -->
                            <script src="assets/js/bear/pages/dashboard.js" type="text/javascript"></script>
							<script src="assets/js/bear/pages/custom/expense/profile.js" type="text/javascript"></script> 
							<script src="assets/js/bear/pages/custom/payment/html-table.js" type="text/javascript"></script> 
						    <script src="assets/js/bear/pages/input-mask.js" type="text/javascript"></script>
							<script src="../assets/js/bear/pages/widgets/bootstrap-datepicker.js" type="text/javascript"></script>
                        <!--end::Page Scripts -->
				     <script>
						
						function get_currency(){
							var payment_supplier_id = $('#payment_supplier_id').val();	
							var payment_account_id = $('#payment_account_id').val();	
							if(payment_supplier_id!="" && payment_account_id!=""){
								$.post("../controllers/payments.php",{payment_supplier_id:payment_supplier_id,payment_account_id:payment_account_id,get_currency:'<?php echo $temp;?>'},function(data){
									
									document.getElementById("html_currency").innerHtml=$("#html_currency").html(data);
									var currency               = $('#currency').val();
									var currency_r_sign        = $('#currency_r_sign').val();
									var curreny_flag           = $('#curreny_flag').val();
	                                var rate                   = $('#rate').val();
									$('#payment_conv_rate').val(rate);
									$('#payment_conv_rate').attr('required', 'required');
									if(rate==1){
											$('#c_rate').hide();	 
									}else{
											$('#c_rate').show();	
									}
									document.getElementById("currency_sign").innerHtml=$("#currency_sign").html(currency);
									document.getElementById("currency_rate_sign").innerHtml=$("#currency_rate_sign").html(currency_r_sign);
									
								});
							}
							
						}
						</script>		
            </body>
    <!-- end::Body -->

</html>
