<?php 
include('../include/security.php');
include('../include/conn.php');
?>
<!DOCTYPE html>
<html lang="en" >
<head>
        <meta charset="utf-8"/>

        <title><?php echo $title;?> - Deposits</title>
        <meta name="description" content="Deposit">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <!--begin::Fonts -->
        <link rel="stylesheet" href="assets/css/bear/fonts.css?family=Poppins:300,400,500,600,700|Roboto:300,400,500,600,700">       <!--end::Fonts -->

        
        
        <!--begin::Global Theme Styles(used by all pages) -->
                    <link href="assets/vendors/global/vendors.bundle.css" rel="stylesheet" type="text/css" />
                    <link href="assets/css/bear/style.bundle.css" rel="stylesheet" type="text/css" />
                <!--end::Global Theme Styles -->

        <!--begin::Layout Skins(used by all pages) -->
                <!--end::Layout Skins -->

        <link rel="shortcut icon" href="assets/media/logos/favicon.png" />

    </head>
    <!-- end::Head -->

    <!-- begin::Body -->
    <body  class="kt-app__aside--left kt-quick-panel--right kt-demo-panel--right kt-offcanvas-panel--right kt-header--fixed kt-header-mobile--fixed kt-subheader--enabled kt-subheader--transparent kt-aside--enabled kt-aside--fixed kt-aside--minimize kt-page--loading"  >

       
    	<!-- begin:: Page -->
	
<!-- begin:: Header Mobile -->
<?php include("../include/header-mobile.php");?>	
<!-- end:: Header Mobile -->
	<div class="kt-grid kt-grid--hor kt-grid--root">
		<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--ver kt-page">
			<!-- begin:: Aside -->
<button class="kt-aside-close " id="kt_aside_close_btn"><i class="la la-close"></i></button>

<?php include("../include/leftside-menu.php");?>	
<div class="kt-aside-menu-overlay"></div>
<!-- end:: Aside --></div>

<div class="kt-aside-menu-overlay"></div>
<!-- end:: Aside -->
			<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor kt-wrapper" id="kt_wrapper">
<!-- begin:: Header -->
<div id="kt_header" class="kt-header kt-grid kt-grid--ver  kt-header--fixed " >
			<!-- begin: Header Menu -->
<button class="kt-header-menu-wrapper-close" id="kt_header_menu_mobile_close_btn"><i class="la la-close"></i></button>
<?php include("../include/header-top-menu.php");?>	
<!-- end: Header Menu -->	
	<!-- begin:: Header Topbar -->
<div class="kt-header__topbar">


	<!--begin: Notifications -->
	<?php include("../include/header-notifications.php");?>	
	<!--end: Notifications -->

	<!--begin: Quick actions -->
    <?php include("../include/header-top-right-quick-btn.php");?>
	<!--end: Quick actions -->



	<!--begin: User bar -->
	<?php include("../include/header-top-right.php");?>
	<!--end: User bar -->


</div>
<!-- end:: Header Topbar -->
</div>
<!-- end:: Header -->
				<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">
											
<!-- begin:: Subheader -->
<div class="kt-subheader   kt-grid__item" id="kt_subheader">
    <div class="kt-container  kt-container--fluid ">
        <div class="kt-subheader__main">
            <h3 class="kt-subheader__title">
					                <button class="kt-subheader__mobile-toggle kt-subheader__mobile-toggle--left" id="kt_subheader_mobile_toggle"><span></span></button>
	            
                Deposits                          </h3>

                            <span class="kt-subheader__separator kt-hidden"></span>
                <div class="kt-subheader__breadcrumbs">
  

                                            <span class="kt-subheader__breadcrumbs-separator"></span>
                        <a href="javascript:" class="kt-subheader__breadcrumbs-link">
                            Add Deposit                        </a>
                                        <!-- <span class="kt-subheader__breadcrumbs-link kt-subheader__breadcrumbs-link--active">Active link</span> -->
                </div>
                    </div>
      
	  
	
	</div>
</div>
<!-- end:: Subheader -->
					
					<!-- begin:: Content -->
	<div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">
		<!--Begin::App-->
<div class="kt-grid kt-grid--desktop kt-grid--ver kt-grid--ver-desktop kt-app">
    <!--Begin:: App Aside Mobile Toggle-->
    <button class="kt-app__aside-close" id="kt_user_profile_aside_close">
        <i class="la la-close"></i>
    </button>
    <!--End:: App Aside Mobile Toggle-->

    <!--Begin:: App Aside-->
    <div class="kt-grid__item kt-app__toggle kt-app__aside" id="kt_user_profile_aside">
        <!--begin:: Widgets/Applications/User/Profile1-->
<div class="kt-portlet kt-portlet--height-fluid-">
    <div class="kt-portlet__head  kt-portlet__head--noborder">
        <div class="kt-portlet__head-label">
            <h3 class="kt-portlet__head-title">
            </h3>
        </div>
   
    </div>
    <div class="kt-portlet__body kt-portlet__body--fit-y">
        <!--begin::Widget -->
        <div class="kt-widget kt-widget--user-profile-1">
     
            <div class="kt-widget__body">
               <form class="kt-form" id="kt_form" action="../controllers/deposits.php?insert=<?php echo base64_encode('deposit');?>" method="POST" enctype="multipart/form-data">               
			   <div class="kt-widget__content">
					<div class="row">		
					 <div class="col-lg-12"> 								
						<div class="form-group">
							<label>Account</label>
							 <select id="deposit_account_id" name="deposit_account_id" class="form-control" required onchange="get_currency();">
								<option value="">Select</option>
								<?php 
								   $accounts= mysqli_query($db,"SELECT * FROM tblaccounts where account_status='Active' order by account_name asc");
								   while($account = mysqli_fetch_array($accounts)){   
								?>
								<option value="<?php echo $account['account_id'];?>"><?php echo $account['account_name'];?> - <?php echo $account['account_currency'];?></option>
								
								<?php } ?>
							</select>
							<!--<span class="form-text text-muted"><a href="#">Add New Account</a></span>-->
						</div>
					 </div>	
					 <div class="col-lg-12"> 								
						<div class="form-group">
							<label>Deposit Date</label>
							<input type="text" class="form-control" id="deposit_date" name="deposit_date" required>
							<span class="form-text text-muted">Please enter your deposit date.</span>
						</div>
					 </div>	
					   <div class="col-lg-12"> 								
						<div class="form-group">
							<label>Description</label>
							<textarea class="form-control"  id="deposit_description" name="deposit_description"></textarea>
							<span class="form-text text-muted">Please enter your deposit description.</span>
						</div>
					 </div>	
					  <div class="col-lg-12"> 								
						<div class="form-group">
							<label>Payer</label>
							<!--<select id="deposit_company_id" name="deposit_company_id" class="form-control kt-selectpicker" onchange="get_currency();" data-size="5" data-live-search="true">-->
							<select id="deposit_company_id" name="deposit_company_id" class="form-control kt-selectpicker" data-size="5" data-live-search="true">
											<option value="">Select</option>
											<?php 
											   $customers= mysqli_query($db,"SELECT * FROM tblcustomers where customer_status='Active' 
											                                  order by customer_company asc");
											   while($customer = mysqli_fetch_array($customers)){   
											?>
											<option value="<?php echo $customer['customer_id'];?>" <?php if($customer['customer_id']==$_GET['id']){echo "selected='selected'";}?>>
										<?php echo $customer['customer_code'];?> - <?php echo $customer['customer_company'];?> - <?php echo $customer['customer_currency'];?></option>
											
											<?php } ?>
										</select>
										<!--<span class="form-text text-muted"><a href="#">Add New Payer</a></span>-->
						</div>
					 </div>	
					   <div id="html_currency"></div>
					 <div class="col-lg-12" id="c_rate" style="display:none;"> 								
						<label style="font-size: 1rem;font-weight: 400;">Conversion Rate</label>
						<div class="input-group">
						
                            <div class="input-group-prepend"><span class="input-group-text" id="currency_rate_sign">PKR</span></div>
                            <input type="text" class="form-control" id="deposit_conv_rate" name="deposit_conv_rate" value="1">
							<span class="form-text text-muted" style="margin-bottom:20px;">Please enter your deposit conversion rate.</span>
                        </div>
					 </div>	
					
					  <div class="col-lg-12"> 								
						<label style="font-size: 1rem;font-weight: 400;">Amount</label>
						<div class="input-group">
						    
                            <div class="input-group-prepend"><span class="input-group-text" id="currency_sign">PKR</span></div>
                            <input type="text" class="form-control" id="deposit_conv_amount" name="deposit_conv_amount" required>
							<span class="form-text text-muted" style="margin-bottom:20px;">Please enter your deposit amount.&nbsp;&nbsp;&nbsp;&nbsp;</span>
                        </div>
					 </div>	
					 
					  <div class="col-lg-12"> 								
						<div class="form-group">
							<label>Ref #</label>
							<input type="text" class="form-control" id="deposit_ref_no" name="deposit_ref_no" >
							<span class="form-text text-muted">Please enter refernce no.</span>
						</div>
					 </div>	
					
					 
					  <div class="col-lg-12" style="display:none;"> 								
						<div class="form-group">
							<label>Notify By</label>
							  <div class="kt-checkbox-inline">
                                                        <label class="kt-checkbox">
                                                            <input type="radio"  id="deposit_notify_by1" name="deposit_notify_by" value="Email"> Email
                                                            <span></span>
                                                        </label>
                                                        <label class="kt-checkbox">
                                                            <input type="radio"  id="deposit_notify_by2" name="deposit_notify_by" value="SMS"> SMS
                                                            <span></span>
                                                        </label>
                                                        <label class="kt-checkbox">
                                                            <input type="radio" id="deposit_notify_by3" name="deposit_notify_by" value="Phone"> Phone
                                                            <span></span>
                                                        </label>
                                                    </div>
						</div>
					 </div>	
					 
					 <div class="col-lg-12"> 								
						<div class="form-group">
							<button class="btn btn-success btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u" data-ktwizard-type="action-submit">
							Submit
						</button>
						</div>
					 </div>	
					 
					</div>
                </div>
               </form>
			 
		   </div>
        </div>
        <!--end::Widget -->
    </div>

	
	
	</div>
<!--end:: Widgets/Applications/User/Profile1-->

     </div>
    <!--End:: App Aside-->

    <!--Begin:: App Content-->
    <div class="kt-grid__item kt-grid__item--fluid kt-app__content">
        <div class="row">
            <div class="col-xl-12">
                <!--begin:: Widgets/Order Statistics-->
<div class="kt-portlet kt-portlet--height-fluid">
	<div class="kt-portlet__head">
		<div class="kt-portlet__head-label">
			<h3 class="kt-portlet__head-title">
				Recent Deposits
			</h3>
		</div>
		<div class="kt-portlet__head-toolbar">
  
		</div>
	</div>
	<div class="kt-portlet__body kt-portlet__body--fluid">
		<div class="kt-widget12">
			<div class="kt-widget12__content">
            		<!--begin: Datatable -->
		<table class="kt-datatable" id="html_table" width="100%">
			<thead>
			<tr>
			    <th>Payer</th>
                <th>Date</th>
				<th>Amount</th>
				<th>Conversion Rate</th>
				<th>Description</th>
				<th>Account</th>
				<th>Ref # </th>
				<th>Notify By</th>
                <th>Action</th>

			</tr>
			</thead>
			<tbody>
			<?php 
			   $deposits= mysqli_query($db,"SELECT * FROM tbldeposits order by deposit_id desc limit 0,50");
			   while($deposit = mysqli_fetch_array($deposits)){  

               	     $accounts= mysqli_query($db,"SELECT account_name,account_currency FROM tblaccounts where account_id = '".$deposit['deposit_account_id']."'");
                     $account = mysqli_fetch_array($accounts);		
                     
					 $customers= mysqli_query($db,"SELECT customer_company,customer_currency FROM tblcustomers where customer_id = '".$deposit['deposit_company_id']."'");
                     $customer = mysqli_fetch_array($customers);	
		    ?>
			<tr>
			    <td><a href="../customers/overview.php?id=<?php echo $deposit['deposit_company_id'];?>" target="_blank"><?php echo $customer['customer_company'];?></a></td>
                <td><?php echo date("d-M-y", strtotime($deposit['deposit_date']));?></td>
				<td><?php echo $customer['customer_currency'];?> <?php if($deposit['deposit_conv_amount']==""){echo "0.00";}else{ echo number_format($deposit['deposit_conv_amount']);}?></td>
				<td><?php echo $deposit['deposit_conv_rate'];?></td>
				<td><?php echo $deposit['deposit_description'];?></td>
                <td><?php echo $account['account_name'];?></td>
				<td><?php echo $deposit['deposit_ref_no'];?></td>
				<td><?php echo $deposit['deposit_notify_by'];?></td> 
				
				<td>
						<a href="javascript:;" class="btn btn-sm btn-clean btn-icon btn-icon-md" title="Delete" onclick="window.location='../controllers/deposits.php?delete=<?php echo base64_encode('deposit');?>&id=<?php echo base64_encode($deposit['deposit_id']);?>';">
							<i class="la la-trash"></i></a>
				</td>
			</tr>
			
			<?php } ?>	
			
			</tbody>
		
		
		
		</table>
		<!--end: Datatable -->    
			</div>
			
		</div>	
            <div class="kt-widget12__chart" style="height:863px;">
				
			</div>		
	</div>
</div>
<!--end:: Widgets/Order Statistics-->            </div>
 
        </div>   
      
	  
	
	</div>
    <!--End:: App Content-->
</div>
<!--End::App-->
	</div>
<!-- end:: Content -->				</div>	
				
				<!-- begin:: Footer -->
<?php include("../include/footer.php");?>
<!-- end:: Footer -->			</div>
		</div>
	</div>
	
<!-- end:: Page -->

<?php include("../include/footer-quick-modal.php");?>
    
    <!-- begin::Scrolltop -->
<div id="kt_scrolltop" class="kt-scrolltop">
		<i class="fa fa-arrow-up"></i>
</div>
<!-- end::Scrolltop -->




						 </div>
                        </div>
                    </div>
             
                </div>
            </div>
        </div>
    </div>
</div>
<?php $temp=base64_encode('get-currency');?>
<!--ENd:: Chat-->
        <!-- begin::Global Config(global config for global JS sciprts) -->
        <script>
            var KTAppOptions = {"colors":{"state":{"brand":"#22b9ff","light":"#ffffff","dark":"#282a3c","primary":"#5867dd","success":"#34bfa3","info":"#36a3f7","warning":"#ffb822","danger":"#fd3995"},"base":{"label":["#c5cbe3","#a1a8c3","#3d4465","#3e4466"],"shape":["#f0f3ff","#d9dffa","#afb4d4","#646c9a"]}}};
        </script>
        <!-- end::Global Config -->

    	<!--begin::Global Theme Bundle(used by all pages) -->
    	    	   <script src="assets/vendors/global/vendors.bundle.js" type="text/javascript"></script>
		    	   <script src="assets/js/bear/scripts.bundle.js" type="text/javascript"></script>
				<!--end::Global Theme Bundle -->

        
                    <!--begin::Page Scripts(used by this page) -->
                            <script src="assets/js/bear/pages/dashboard.js" type="text/javascript"></script>
							<script src="assets/js/bear/pages/custom/expense/profile.js" type="text/javascript"></script> 
							<script src="assets/js/bear/pages/html-table.js" type="text/javascript"></script> 
						    <script src="assets/js/bear/pages/input-mask.js" type="text/javascript"></script>
							<script src="../assets/js/bear/pages/widgets/bootstrap-datepicker.js" type="text/javascript"></script>
                        <!--end::Page Scripts -->
				    <script>
						
						function get_currency(){
							var deposit_account_id = $('#deposit_account_id').val();	
							var deposit_company_id = $('#deposit_company_id').val();	
							if(deposit_account_id!="" && deposit_company_id!=""){
								$.post("../controllers/deposits.php",{deposit_account_id:deposit_account_id,deposit_company_id:deposit_company_id,get_currency:'<?php echo $temp;?>'},function(data){							
										
										document.getElementById("html_currency").innerHtml=$("#html_currency").html(data);
										var currency               = $('#currency').val();
										var currency_r_sign        = $('#currency_r_sign').val();
										var curreny_flag           = $('#curreny_flag').val();
										var rate                   = $('#rate').val();
										$('#deposit_conv_rate').val(rate);
										$('#deposit_conv_rate').attr('required', 'required');
										if(rate==1){
											$('#c_rate').hide();	 
										}else{
											$('#c_rate').show();	
										}
										document.getElementById("currency_sign").innerHtml=$("#currency_sign").html(currency);
										document.getElementById("currency_rate_sign").innerHtml=$("#currency_rate_sign").html(currency_r_sign);
									
									
								});
							}
							
						}
						</script>		
						<script src="assets/js/bear/pages/bootstrap-select.js" type="text/javascript"></script>
            </body>
    <!-- end::Body -->

</html>
