"use strict";

// Class definition
var KTContactsAdd = function () {
	// Base elements
	var wizardEl;
	var formEl;
	var validator;
	var wizard;
	var avatar;
	
	// Private functions
	var initWizard = function () {
		// Initialize form wizard
		wizard = new KTWizard('kt_contacts_add', {
			startStep: 1,
		});

		// Validation before going to next page
		wizard.on('beforeNext', function(wizardObj) {
			if (validator.form() !== true) {
				wizardObj.stop();  // don't go to the next step
			}
		})

		// Change event
		wizard.on('change', function(wizard) {
			KTUtil.scrollTop();	
			if (wizard.getStep() === 4) {
				
				var supplier_first_name = $("#supplier_first_name").val();
				var supplier_last_name  = $("#supplier_last_name").val();
				var supplier_company    = $("#supplier_company").val();
				var supplier_phone      = $("#supplier_phone").val();
				var supplier_email      = $("#supplier_email").val();
				var supplier_website    = $("#supplier_website").val();
				
				
				var supplier_currency      = $("#supplier_currency").val();
				var supplier_bank_name     = $("#supplier_bank_name").val();
				var supplier_account_no    = $("#supplier_account_no").val();
				var supplier_account_title = $("#supplier_account_title").val();
				
				
				
				var supplier_address        = $("#supplier_address").val();
				var supplier_postal_code    = $("#supplier_postal_code").val();
				var supplier_city           = $("#supplier_city").val();
				var supplier_state          = $("#supplier_state").val();
				var supplier_country        = $("#supplier_country").val();
				$.post("../controllers/suppliers.php",{supplier_first_name:supplier_first_name,supplier_last_name:supplier_last_name,supplier_company:supplier_company,
				                               supplier_phone:supplier_phone,supplier_email:supplier_email,supplier_website:supplier_website,
											   supplier_currency:supplier_currency,
											   supplier_bank_name:supplier_bank_name,supplier_account_no:supplier_account_no,supplier_account_title:supplier_account_title,
											   supplier_address:supplier_address,supplier_postal_code:supplier_postal_code,
											   supplier_city:supplier_city,supplier_state:supplier_state,supplier_country:supplier_country,html_review:'html_review'},function(data){
					
		                document.getElementById("html_review").innerHtml=$("#html_review").html(data);
						

	            });
            } 
		});
	}

	var initValidation = function() {
		validator = formEl.validate({
			// Validate only visible fields
			ignore: ":hidden",

			// Validation rules
			rules: {
				// Step 1
				profile_avatar: {
					//required: true 
				},
				profile_first_name: {
					required: true
				},	   
				profile_last_name: {
					required: true
				},
				profile_phone: {
					required: true
				},	 
				profile_email: {
					required: true,
					email: true
				}
			},
			
			// Display error  
			invalidHandler: function(event, validator) {	 
				KTUtil.scrollTop();

				swal.fire({
					"title": "", 
					"text": "There are some errors in your submission. Please correct them.", 
					"type": "error",
					"buttonStyling": false,
					"confirmButtonClass": "btn btn-brand btn-sm btn-bold"
				});
			},

			// Submit valid form
			submitHandler: function (form) {
				
			}
		});   
	}

	var initSubmit = function() {
		var btn = formEl.find('[data-ktwizard-type="action-submit"]');

		btn.on('click', function(e) {
			e.preventDefault();

			if (validator.form()) {
				// See: src\js\framework\base\app.js
				KTApp.progress(btn);
				//KTApp.block(formEl);

				// See: http://malsup.com/jquery/form/#ajaxSubmit
				formEl.ajaxSubmit({
					success: function() {
						KTApp.unprogress(btn);
						//KTApp.unblock(formEl);
                         window.location='suppliers.php';
						//swal.fire({
							//"title": "", 
							//"text": "The application has been successfully submitted!", 
							//"type": "success",
							//"confirmButtonClass": "btn btn-secondary"
						//});
					}
				});
			}
		});
	}
	 
	var initAvatar = function() {
		avatar = new KTAvatar('kt_contacts_add_avatar');
	}	

	return {
		// public functions
		init: function() {
			formEl = $('#kt_contacts_add_form');

			initWizard(); 
			initValidation();
			initSubmit();
			initAvatar(); 
		}
	};
}();

jQuery(document).ready(function() {	
	KTContactsAdd.init();
});