"use strict";

// Class definition
var KTWizard2 = function () {
    // Base elements
    var wizardEl;
    var formEl;
    var validator;
    var wizard;
    
    // Private functions
    var initWizard = function () {
        // Initialize form wizard
        wizard = new KTWizard('kt_wizard_v2', {
            startStep: 1,
        });

        // Validation before going to next page
        wizard.on('beforeNext', function(wizardObj) {
            if (validator.form() !== true) {
                wizardObj.stop();  // don't go to the next step
            }
        });

        wizard.on('beforePrev', function(wizardObj) {
			if (validator.form() !== true) {
				wizardObj.stop();  // don't go to the next step
			}
		});

        // Change event
        wizard.on('change', function(wizard) {
            KTUtil.scrollTop();    

			if (wizard.getStep() === 3) {
				
				var invoice_id             = $("#invoice_id").val();
				var invoice_description    = $("#invoice_description").val();
				var project_id             = $("#project_id").val();
				var customer_company       = $("#customer_company").val();
				var customer_currency       = $("#customer_currency").val();
				var invoice_date           = $("#invoice_date").val();
				var invoice_category       = $("#invoice_category").val();
				var invoice_recurring      = $("#invoice_recurring").val();
				var invoice_recurring_day  = $("#invoice_recurring_day").val();
				var invoice_note           = $("#invoice_note").val();
				
				$.post("../controllers/invoices.php",{invoice_id:invoice_id,invoice_description:invoice_description,project_id:project_id,
				                               customer_company:customer_company,customer_currency:customer_currency,invoice_date:invoice_date,invoice_category:invoice_category,
											   invoice_recurring:invoice_recurring,invoice_recurring_day:invoice_recurring_day,invoice_note:invoice_note,
											   html_review:'edit_html_review'},function(data){
					
		                document.getElementById("html_review").innerHtml=$("#html_review").html(data);
						

	            });
            } 
			
        });
    }

    var initValidation = function() {
        validator = formEl.validate({
            // Validate only visible fields
            ignore: ":hidden",

            // Validation rules
            rules: {
               	//= Step 1
				fname: {
					required: true 
				},
				lname: {
					required: true
				},	   
				phone: {
					required: true
				},	 
				emaul: {
					required: true,
					email: true
				},	 

				//= Step 2
				address1: {
					required: true 
				},
				postcode: {
					required: true
				},	   
				city: {
					required: true
				},	 
				state: {
					required: true
				},	 
				country: {
					required: true
				},	 	   

				//= Step 3
				delivery: {
					required: true
				},
				packaging: {
					required: true
				},	
				preferreddelivery: {
					required: true
				},	

				//= Step 4
				locaddress1: {
					required: true 
				},
				locpostcode: {
					required: true
				},	   
				loccity: {
					required: true
				},	 
				locstate: {
					required: true
				},	 
				loccountry: {
					required: true
				},

				//= Step 5
				ccname: {
					required: true 
				},
				ccnumber: {
					required: true,
					creditcard: true
				},	   
				ccmonth: {
					required: true
				},	 
				ccyear: {
					required: true
				},	 
				cccvv: {
					required: true,					
					minlength: 2,
					maxlength: 3
				},	
            },
            
            // Display error  
            invalidHandler: function(event, validator) {     
                KTUtil.scrollTop();

                swal.fire({
                    "title": "", 
                    "text": "There are some errors in your submission. Please correct them.", 
                    "type": "error",
                    "confirmButtonClass": "btn btn-secondary"
                });
            },

            // Submit valid form
            submitHandler: function (form) {
                
            }
        });   
    }

    var initSubmit = function() {
        var btn = formEl.find('[data-ktwizard-type="action-submit"]');
        var invoice_id = $("#invoice_id").val();
        btn.on('click', function(e) {
            e.preventDefault();

            if (validator.form()) {
                // See: src\js\framework\base\app.js
                KTApp.progress(btn);
                //KTApp.block(formEl);

                // See: http://malsup.com/jquery/form/#ajaxSubmit
                formEl.ajaxSubmit({
					data: { action: 'submit',invoice_id:invoice_id},
                    success: function() {
                        KTApp.unprogress(btn);
                        //KTApp.unblock(formEl);
                         window.location='preview.php?id='+invoice_id;
                        /*swal.fire({
                            "title": "", 
                            "text": "The application has been successfully submitted!", 
                            "type": "success",
                            "confirmButtonClass": "btn btn-secondary"
                        });*/
                    }
                });
            }
        });
    }

    return {
        // public functions
        init: function() {
            wizardEl = KTUtil.get('kt_wizard_v2');
            formEl = $('#kt_form');

            initWizard(); 
            initValidation();
            initSubmit();
        }
    };
}();

jQuery(document).ready(function() {    
    KTWizard2.init();
});