<?php 
include('../include/security.php');
include('../include/conn.php');
$purchases= mysqli_query($db,"SELECT * FROM tblpurchases order by purchase_id desc limit 0,1");
$purchase = mysqli_fetch_array($purchases);
$purchase_id = $purchase['purchase_id'] + 1;
?>
<!DOCTYPE html>
<head>
        <meta charset="utf-8"/>

        <title><?php echo $title;?> - Add Purchase</title>
        <meta name="description" content="Add Purchase">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <!--begin::Fonts -->
        <link rel="stylesheet" href="assets/css/bear/fonts.css?family=Poppins:300,400,500,600,700|Roboto:300,400,500,600,700">        <!--end::Fonts -->

        
                    <!--begin::Page Custom Styles(used by this page) -->
                             <link href="assets/css/bear/pages/wizard/wizard-2.css" rel="stylesheet" type="text/css" />
                        <!--end::Page Custom Styles -->
        
        <!--begin::Global Theme Styles(used by all pages) -->
                    <link href="assets/vendors/global/vendors.bundle.css" rel="stylesheet" type="text/css" />
                    <link href="assets/css/bear/style.bundle.css" rel="stylesheet" type="text/css" />
                <!--end::Global Theme Styles -->

        <!--begin::Layout Skins(used by all pages) -->
                <!--end::Layout Skins -->

        <link rel="shortcut icon" href="assets/media/logos/favicon.png" />
        <style>
		.inv{color:#000;background-color:#f5f6fc;padding: 0.65rem 1rem;border-radius: 4px;font-family: Poppins;}
		</style>
    </head>
    <!-- end::Head -->

    <!-- begin::Body -->
    <body  class="kt-quick-panel--right kt-demo-panel--right kt-offcanvas-panel--right kt-header--fixed kt-header-mobile--fixed kt-subheader--enabled kt-subheader--transparent kt-aside--enabled kt-aside--fixed kt-aside--minimize kt-page--loading"  >

       
    	<!-- begin:: Page -->
	
<!-- begin:: Header Mobile -->
<?php include("../include/header-mobile.php");?>	
<!-- end:: Header Mobile -->
	<div class="kt-grid kt-grid--hor kt-grid--root">
		<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--ver kt-page">
			<!-- begin:: Aside -->
<button class="kt-aside-close " id="kt_aside_close_btn"><i class="la la-close"></i></button>

<?php include("../include/leftside-menu.php");?>	
<div class="kt-aside-menu-overlay"></div>
<!-- end:: Aside -->
<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor kt-wrapper" id="kt_wrapper">
<!-- begin:: Header -->
<div id="kt_header" class="kt-header kt-grid kt-grid--ver  kt-header--fixed " >
			<!-- begin: Header Menu -->
<button class="kt-header-menu-wrapper-close" id="kt_header_menu_mobile_close_btn"><i class="la la-close"></i></button>
<?php include("../include/header-top-menu.php");?>	
<!-- end: Header Menu -->	
	<!-- begin:: Header Topbar -->
<div class="kt-header__topbar">


	<!--begin: Notifications -->
	<?php include("../include/header-notifications.php");?>	
	<!--end: Notifications -->

	<!--begin: Quick actions -->
    <?php include("../include/header-top-right-quick-btn.php");?>
	<!--end: Quick actions -->



	<!--begin: User bar -->
	<?php include("../include/header-top-right.php");?>
	<!--end: User bar -->


</div>
<!-- end:: Header Topbar -->
</div>
<!-- end:: Header -->
				<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">
											
<!-- begin:: Subheader -->
<div class="kt-subheader   kt-grid__item" id="kt_subheader">
    <div class="kt-container  kt-container--fluid ">
         <div class="kt-subheader__main">
            
            <h3 class="kt-subheader__title">
                                    Add Purchase                           
            </h3>

            <span class="kt-subheader__separator kt-subheader__separator--v"></span>
            
            <div class="kt-subheader__group" id="kt_subheader_search">
                <span class="kt-subheader__desc" id="kt_subheader_total">
                                            Enter purchase details and submit                                    </span>
                
                            </div>

                    </div> 
      <div class="kt-subheader__toolbar">

                            <a href="<?php echo $url;?>/index.php" class="btn btn-default btn-bold">
                    
                    Back                </a>
            
                                       
                    </div>
   </div>
</div>
<!-- end:: Subheader -->
					
					<!-- begin:: Content -->
	<div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">
		<div class="kt-portlet">
	<div class="kt-portlet__body kt-portlet__body--fit">
		<div class="kt-grid  kt-wizard-v2 kt-wizard-v2--white" id="kt_wizard_v2" data-ktwizard-state="step-first">
			<div class="kt-grid__item kt-wizard-v2__aside">
				<!--begin: Form Wizard Nav -->
				<div class="kt-wizard-v2__nav">
					<div class="kt-wizard-v2__nav-items">
						<!--doc: Replace A tag with SPAN tag to disable the step link click -->
						<a class="kt-wizard-v2__nav-item" href="#" data-ktwizard-type="step" data-ktwizard-state="current">
							<div class="kt-wizard-v2__nav-body">
								<div class="kt-wizard-v2__nav-icon">
									<i class="flaticon-globe"></i>
								</div>
								<div class="kt-wizard-v2__nav-label">
									<div class="kt-wizard-v2__nav-label-title">
										Purchase Header
									</div>
									<div class="kt-wizard-v2__nav-label-desc">
										Setup Your Purchase Header
									</div>
								</div>
							</div>
						</a>
						<a class="kt-wizard-v2__nav-item" href="#" data-ktwizard-type="step">
							<div class="kt-wizard-v2__nav-body">
								<div class="kt-wizard-v2__nav-icon">
									<i class="flaticon-bus-stop"></i>
								</div>
								<div class="kt-wizard-v2__nav-label">
									<div class="kt-wizard-v2__nav-label-title">
										Purchase Items
									</div>
									<div class="kt-wizard-v2__nav-label-desc">
										Enter Your Items Details
									</div>
								</div>
							</div>
						</a>
					
						
						<a class="kt-wizard-v2__nav-item" href="#" data-ktwizard-type="step">
							<div class="kt-wizard-v2__nav-body">
								<div class="kt-wizard-v2__nav-icon">
									<i class="flaticon-confetti"></i>
								</div>
								<div class="kt-wizard-v2__nav-label">
									<div class="kt-wizard-v2__nav-label-title">
										Completed!
									</div>
									<div class="kt-wizard-v2__nav-label-desc">
										Review and Submit
									</div>
								</div>
							</div>
						</a>
					</div>
				</div>
				<!--end: Form Wizard Nav -->

			</div>
			<div class="kt-grid__item kt-grid__item--fluid kt-wizard-v2__wrapper">
				<!--begin: Form Wizard Form-->
				<form class="kt-form" id="kt_form" action="../controllers/purchases.php?insert=<?php echo base64_encode('purchase');?>" method="POST">
					<!--begin: Form Wizard Step 1-->
					<div class="kt-wizard-v2__content" data-ktwizard-type="step-content" data-ktwizard-state="current">
						<div class="kt-heading kt-heading--md">Enter your Purchase Header Details</div>
						<div class="kt-form__section kt-form__section--first">
							<div class="kt-wizard-v2__form">
							  <div class="row">
							  <div class="col-lg-3"> 
								<div class="form-group">
									<label>Purchase No</label>
									<input type="text" class="form-control" id="purchase_id" name="purchase_id" value="<?php echo $purchase_id;?>" disabled>
									
								</div>
							   </div>
                              </div>	
							  <div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<label>Purchase Title </label>
											<input type="text" class="form-control" id="purchase_description" name="purchase_description" value="Purchase Invoice" required>
											<span class="form-text text-muted">Please enter your purchase title.</span>
									
										</div>
										</div>
										<div class="col-lg-6">
										<div class="form-group">
											<label>Date</label>
											<input type="text" class="form-control" id="purchase_date" name="purchase_date" required value="<?php echo date('m/d/Y');?>">
											<span class="form-text text-muted">Please enter your purchase date.</span>
										</div>
									</div>
										
									
									
									
								</div>
                               	<div class="row">		
                                 <div class="col-lg-12"> 								
									<div class="form-group">
										<label>Supplier Name</label>
										 <select id="supplier_id" name="supplier_id" class="form-control kt-selectpicker" required onChange="get_supplier_balance(this.value);"  data-size="5" data-live-search="true">
											<option value="">Select</option>
											<?php
											   $suppliers= mysqli_query($db,"SELECT * FROM tblsuppliers order by supplier_company asc");
											   while($supplier = mysqli_fetch_array($suppliers)){   
											  
											?>
											<option value="<?php echo $supplier['supplier_id'];?>"><?php echo $supplier['supplier_company'];?>  
											
											</option>
											
											<?php } ?>
										</select>
									</div>
								 </div>	
								</div>
								<div class="row" id="html_company">
                                 <div class="col-lg-6"> 									
									<div class="form-group">
										<label>Current Balance</label>
										<input type="text" class="form-control" id="supplier_balance" name="supplier_balance"  disabled value="0">
										
									</div>
								 </div>	
								 
								 
								 
								  <div class="col-lg-6"> 									
									<div class="form-group">
										<label>Currency</label>
										
										<input type="text" class="form-control" id="supplier_currency" name="supplier_currency"  disabled value="">
									</div>
								 </div>	
								</div>
								
							
						
                                 
                            
								
							
								
							</div>
						</div>
					</div>
					<!--end: Form Wizard Step 1-->

					<!--begin: Form Wizard Step 2-->
					<div class="kt-wizard-v2__content" data-ktwizard-type="step-content">
						<div class="kt-heading kt-heading--md">Enter Your Items Details</div>
						<div class="kt-form__section kt-form__section--first">
							<div class="kt-wizard-v2__form">
								<div class="row">
									<div class="col-lg-4">
										<div class="form-group">
											<label>Item Name</label>
											<!--<input type="text" class="form-control" id="purchase_item" name="purchase_item" >-->
											<select class="form-control kt-selectpicker" data-size="5" data-live-search="true"  id="purchase_item" name="purchase_item">
											<option value="">Select</option>
											<?php
											   $products= mysqli_query($db,"SELECT * FROM tblproducts order by product_name asc");
											   while($product = mysqli_fetch_array($products)){   
											  
											?>
											<option value="<?php echo $product['product_id'];?>"><?php echo $product['product_code'];?> - <?php echo $product['product_name'];?>(<?php echo number_format(round($product['product_qty']));?>)  
											
											</option>
											
											<?php } ?>
											
											</select>
										</div>
									</div>
									
									<div class="col-lg-2">
										<div class="form-group">
											<label>Quantity</label>
											<input type="text" class="form-control" id="purchase_item_qty" name="purchase_item_qty"   >
											
										</div>
									</div>
									
									 <div class="col-lg-3"> 								
										<label style="font-size: 1rem;font-weight: 400;">Price</label>
										<div class="input-group">
											
											<div class="input-group-prepend"><span class="input-group-text" id="currency_sign">PKR</span></div>
											<input type="text" class="form-control" id="purchase_item_price" name="purchase_item_price">
											<span class="form-text text-muted" style="margin-bottom:20px;"></span>
										</div>
									 </div>	
									
									<div class="col-lg-2">
										<div class="form-group">
											<label>Discount(%)</label>
											<input type="text" class="form-control" id="purchase_discount" name="purchase_discount" value='0.00' >
											
										</div>
									</div>
									<div class="col-lg-1">
										<div class="form-group">
											<label>&nbsp;</label>
											<input type="button" class="form-control" id="purchase_button" name="purchase_button" value="+" onClick="add_temp_purchase_detail();">
											
										</div>
									</div>
									
								</div>
								<div class="row" style="border-bottom: 1px dashed #ebedf2;">
									<div class="col-lg-4">
										<div class="form-group">
											<label>Item Name</label>
										</div>
									</div>
									
									<div class="col-lg-1">
										<div class="form-group">
											<label>Quantity</label>
										</div>
									</div>
									
									<div class="col-lg-2">
										<div class="form-group">
											<label>Price</label>
										</div>
									</div>
									
									<div class="col-lg-2">
										<div class="form-group">
											<label>Discount(%)</label>
										</div>
									</div>
									
									<div class="col-lg-2">
										<div class="form-group">
											<label>Total</label>										
										</div>
									</div>
									
									<div class="col-lg-1">
										<div class="form-group">
											<label>Action</label>										
										</div>
									</div>
								</div>
							    <br>
								<div id="loading" align="center" style="display:none;"><img src="assets/media/loading.gif" width="50" height="50"></div>
								<div id="inv_detail">
								<?php if(isset($_SESSION['purchase_id'])){?>
								<?php $purchase_details= mysqli_query($db,"SELECT * FROM tbltemppurchases where purchase_id = '".$_SESSION['purchase_id']."'");
                                      while($purchase_detail = mysqli_fetch_array($purchase_details)){
                                          
                                          
                                           $products= mysqli_query($db,"SELECT * FROM tblproducts where product_id = '".$purchase_detail['purchase_item']."'");
		$product = mysqli_fetch_array($products);
                                          
							    ?>
								<div class="row inv" id="row_inv<?php echo $purchase_detail['purchase_temp_id'];?>">
									<div class="col-lg-4">
										<div class="inv">
											<label><?php echo $product['product_name'];?></label>
										</div>
									</div>
									
									<div class="col-lg-1">
										<div class="inv">
											<label><?php echo number_format($purchase_detail['purchase_item_qty']);?></label>
										</div>
									</div>
									
									<div class="col-lg-2">
										<div class="inv">
											<label><?php echo $purchase_detail['purchase_item_currency'];?> <?php echo number_format($purchase_detail['purchase_item_price']);?></label>
										</div>
									</div>
									
									<div class="col-lg-2">
										<div class="inv">
											<label><?php echo number_format($purchase_detail['purchase_discount']);?> % = <?php echo (($purchase_detail['purchase_discount']/100)*$purchase_detail['purchase_item_price'])*$purchase_detail['purchase_item_qty'];?></label>
										</div>
									</div>
									
									<div class="col-lg-2">
										<div class="inv">
											<label><?php echo $purchase_detail['purchase_item_currency'];?> <?php 
											
											
											$purchase_discount='';
        
        $purchase_discount = ($purchase_detail['purchase_discount']/100)*$purchase_detail['purchase_item_price'];
											
											$total= ( $purchase_detail['purchase_item_qty'] * $purchase_detail['purchase_item_price'] ) -  ($purchase_detail['purchase_item_qty'] * $purchase_discount); echo number_format($total);?></label>
										</div>
									</div>
									<div class="col-lg-1">
									<!--<a href="javascript:;" class="btn btn-sm btn-clean btn-icon btn-icon-md" title="Edit" onClick="edit_temp_item('<?php //echo $purchase_detail['purchase_temp_id'];?>');">
										<i class="la la-edit"></i>
									</a>-->
									<a href="javascript:;" class="btn btn-sm btn-clean btn-icon btn-icon-md" title="Delete" onClick="delete_temp_item('<?php echo $purchase_detail['purchase_temp_id'];?>');">
										<i class="la la-trash"></i></a>
									</div>
								</div>
								<br>
								<?php }
								}
								?>
								</div>
								<br>
								<br>
								<div class="row">
                                 <!--<div class="col-lg-3"> 									
									<div class="form-group">
										<label>Bility Date</label>
										<input type="text" class="form-control" id="purchase_b_date" name="purchase_b_date"   >
										
									</div>
								 </div>	
								 
								 
								 
								  <div class="col-lg-3"> 									
									<div class="form-group">
										<label>Bility Number</label>
										
										<input type="text" class="form-control" id="purchase_b_no" name="purchase_b_no"  >
									</div>
								 </div>	
								 
								 <div class="col-lg-3"> 									
									<div class="form-group">
										<label>Bility Amount</label>
										
										<input type="text" class="form-control" id="purchase_b_amount" name="purchase_b_amount"  >
									</div>
								 </div>	-->
								 
								 <div class="col-lg-3"> 									
									<div class="form-group">
										<label>Discount(%)</label>
										
										<input type="text" class="form-control" id="purchase_d_amount" name="purchase_d_amount"  >
									</div>
								 </div>	
								</div>
							</div>
						</div>
					</div>
					<!--end: Form Wizard Step 2-->


					<!--begin: Form Wizard Step 6-->
					<div class="kt-wizard-v2__content" data-ktwizard-type="step-content">
						<div class="kt-heading kt-heading--md">Review your Details and Submit</div>
						<div class="kt-form__section kt-form__section--first">
							<div class="kt-wizard-v2__review" id="html_review">
								<div class="kt-wizard-v2__review-item">
									<div class="kt-wizard-v2__review-title">
										purchase Header Details
									</div>
									<div class="kt-wizard-v2__review-content">
										John Wick<br/>
										Phone: +61412345678<br/>
										Email: johnwick@reeves.com
									</div>
								</div>
								<div class="kt-wizard-v2__review-item">
									<div class="kt-wizard-v2__review-title">
										purchase Items Details
									</div>
									<div class="kt-wizard-v2__review-content">
										Address Line 1<br/>
										Address Line 2<br/>
										Melbourne 3000, VIC, Australia
									</div>
								</div>
								
								
								
							</div>
						</div>
					</div>
					<!--end: Form Wizard Step 6-->

					<!--begin: Form Actions -->
					<div class="kt-form__actions">
						<button class="btn btn-secondary btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u" data-ktwizard-type="action-prev">
							Previous
						</button>
						<button class="btn btn-success btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u" data-ktwizard-type="action-submit">
							Submit
						</button>
						<button class="btn btn-brand btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u" data-ktwizard-type="action-next">
							Next Step
						</button>
					</div>
					<!--end: Form Actions -->
				</form>
				<!--end: Form Wizard Form-->
			</div>
		</div>
	</div>
</div>
	</div>
<!-- end:: Content -->				</div>	
				
				<!-- begin:: Footer -->
<?php include("../include/footer.php");?>
<!-- end:: Footer -->			</div>
		</div>
	</div>
	
<!-- end:: Page -->

<?php include("../include/footer-quick-modal.php");?>
    
    <!-- begin::Scrolltop -->
<div id="kt_scrolltop" class="kt-scrolltop">
		<i class="fa fa-arrow-up"></i>
</div>
<!-- end::Scrolltop -->


              
							
							</div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $temp=base64_encode('temp-purchase');?>
<?php $temp2=base64_encode('get_supplier_balance');?>
<?php $temp3=base64_encode('edit-temp-item');?>
<?php $temp4=base64_encode('delete-temp-item');?>
<?php $temp5=base64_encode('get-price');?>
<!--ENd:: Chat-->
        <!-- begin::Global Config(global config for global JS sciprts) -->
        <script>
            var KTAppOptions = {"colors":{"state":{"brand":"#22b9ff","light":"#ffffff","dark":"#282a3c","primary":"#5867dd","success":"#34bfa3","info":"#36a3f7","warning":"#ffb822","danger":"#fd3995"},"base":{"label":["#c5cbe3","#a1a8c3","#3d4465","#3e4466"],"shape":["#f0f3ff","#d9dffa","#afb4d4","#646c9a"]}}};
        </script>
        <!-- end::Global Config -->

    	<!--begin::Global Theme Bundle(used by all pages) -->
    	    	   <script src="assets/vendors/global/vendors.bundle.js" type="text/javascript"></script>
		    	   <script src="assets/js/bear/scripts.bundle.js" type="text/javascript"></script>
				<!--end::Global Theme Bundle -->

        
                    <!--begin::Page Scripts(used by this page) -->
                            <script src="assets/js/bear/pages/wizard/wizard-purchase-2.js" type="text/javascript"></script>
							<script src="../assets/js/bear/pages/widgets/bootstrap-datepicker.js" type="text/javascript"></script>
                        <!--end::Page Scripts -->
						<script>
					
					
						
						function add_temp_purchase_detail(){
							var purchase_item            = $('#purchase_item').val();
							var purchase_item_desciption = $('#purchase_item_desciption').val();
							var purchase_item_qty        = $('#purchase_item_qty').val();
							var purchase_item_price      = $('#purchase_item_price').val();
							var purchase_discount        = $('#purchase_discount').val();
							var customer_currency       = $('#customer_currency').val();
							$('#loading').show();	
							$.post("../controllers/purchases.php",{purchase_item:purchase_item,purchase_item_desciption:purchase_item_desciption,purchase_item_qty:purchase_item_qty,
							purchase_item_price:purchase_item_price,purchase_discount:purchase_discount,customer_currency:customer_currency,
							insert_temp:'<?php echo $temp;?>'},function(data){
								document.getElementById("inv_detail").innerHtml=$("#inv_detail").html(data);
								$('#purchase_item').val("");
								$('#purchase_item_desciption').val("");
								$('#purchase_item_qty').val("");
								$('#purchase_item_price').val("");
								$('#purchase_discount').val("0.00");
								$("#purchase_item").focus();
								$('#loading').hide();
						    });
						}
						
						function get_supplier_balance(supplier_id){
								
							$.post("../controllers/purchases.php",{supplier_id:supplier_id,get_supplier_balance:'<?php echo $temp2;?>'},function(data){
								document.getElementById("html_company").innerHtml=$("#html_company").html(data);
								
								
						    });
							
						}
						
						function get_price(product_id){
								
							$.post("../controllers/purchases.php",{product_id:product_id,get_price:'<?php echo $temp5;?>'},function(data){
								$('#purchase_item_price').val(data);
								
								
						    });
							
						}
						
						function edit_temp_item(temp_id){
							$('#loading').show();	
							$.post("../controllers/purchases.php",{temp_id:temp_id,edit_item:'<?php echo $temp3;?>'},function(data){
								document.getElementById("row_inv"+temp_id).innerHtml=$("#row_inv"+temp_id).html(data);
								$('#loading').hide();	
								
						    });
							
						}
						function delete_temp_item(temp_id){
							var customer_currency       = $('#customer_currency').val();
							$('#loading').show();	
							$.post("../controllers/purchases.php",{temp_id:temp_id,customer_currency:customer_currency,delete_item:'<?php echo $temp4;?>'},function(data){
								document.getElementById("inv_detail").innerHtml=$("#inv_detail").html(data);
								$('#loading').hide();	
								
						    });
							
						}
						</script>
						<script src="assets/js/bear/pages/html-table.js" type="text/javascript"></script> 
						<script src="assets/js/bear/pages/input-mask.js" type="text/javascript"></script>
						<script src="assets/js/bear/pages/bootstrap-select.js" type="text/javascript"></script>
            </body>
    <!-- end::Body -->

</html>
