"use strict";

// Class definition
var KTContactsAdd = function () {
	// Base elements
	var wizardEl;
	var formEl;
	var validator;
	var wizard;
	var avatar;
	
	// Private functions
	var initWizard = function () {
		// Initialize form wizard
		wizard = new KTWizard('kt_contacts_add', {
			startStep: 1,
		});

		// Validation before going to next page
		wizard.on('beforeNext', function(wizardObj) {
			if (validator.form() !== true) {
				wizardObj.stop();  // don't go to the next step
			}
		})

		// Change event
		wizard.on('change', function(wizard) {
			KTUtil.scrollTop();	
			
			if (wizard.getStep() === 4) {
				
				var customer_first_name = $("#customer_first_name").val();
				var customer_last_name  = $("#customer_last_name").val();
				var customer_company    = $("#customer_company").val();
				var customer_phone      = $("#customer_phone").val();
				var customer_email      = $("#customer_email").val();
				var customer_website    = $("#customer_website").val();
				
				
				var customer_username      = $("#customer_username").val();
				var customer_password      = $("#customer_password").val();
				var customer_currency      = $("#customer_currency").val();
				var customer_invoice_date  = $("#customer_invoice_date").val();
				
				
				
				var customer_address        = $("#customer_address").val();
				var customer_postal_code    = $("#customer_postal_code").val();
				var customer_city           = $("#customer_city").val();
				var customer_state          = $("#customer_state").val();
				var customer_country        = $("#customer_country").val();
				$.post("../controllers/customers.php",{customer_first_name:customer_first_name,customer_last_name:customer_last_name,customer_company:customer_company,
				                               customer_phone:customer_phone,customer_email:customer_email,customer_website:customer_website,
											   customer_username:customer_username,customer_password:customer_password,customer_currency:customer_currency,
											   customer_invoice_date:customer_invoice_date,customer_address:customer_address,customer_postal_code:customer_postal_code,
											   customer_city:customer_city,customer_state:customer_state,customer_country:customer_country,html_review:'html_review'},function(data){
					
		                document.getElementById("html_review").innerHtml=$("#html_review").html(data);
						

	            });
            } 
		});
	}

	var initValidation = function() {
		validator = formEl.validate({
			// Validate only visible fields
			ignore: ":hidden",

			// Validation rules
			rules: {
				// Step 1
				profile_avatar: {
					//required: true 
				},
				profile_first_name: {
					required: true
				},	   
				profile_last_name: {
					required: true
				},
				profile_phone: {
					required: true
				},	 
				profile_email: {
					required: true,
					email: true
				}
			},
			
			// Display error  
			invalidHandler: function(event, validator) {	 
				KTUtil.scrollTop();

				swal.fire({
					"title": "", 
					"text": "There are some errors in your submission. Please correct them.", 
					"type": "error",
					"buttonStyling": false,
					"confirmButtonClass": "btn btn-brand btn-sm btn-bold"
				});
			},

			// Submit valid form
			submitHandler: function (form) {
				
			}
		});   
	}

	var initSubmit = function() {
		var btn = formEl.find('[data-ktwizard-type="action-submit"]');

		btn.on('click', function(e) {
			e.preventDefault();

			if (validator.form()) {
				// See: src\js\framework\base\app.js
				KTApp.progress(btn);
				//KTApp.block(formEl);

				// See: http://malsup.com/jquery/form/#ajaxSubmit
				formEl.ajaxSubmit({
					success: function() {
						KTApp.unprogress(btn);
						//KTApp.unblock(formEl);
                         window.location='customers.php';
						//swal.fire({
							//"title": "", 
							//"text": "The application has been successfully submitted!", 
							//"type": "success",
							//"confirmButtonClass": "btn btn-secondary"
						//});
					}
				});
			}
		});
	}
	 
	var initAvatar = function() {
		avatar = new KTAvatar('kt_contacts_add_avatar');
	}	

	return {
		// public functions
		init: function() {
			formEl = $('#kt_contacts_add_form');

			initWizard(); 
			initValidation();
			initSubmit();
			initAvatar(); 
		}
	};
}();

jQuery(document).ready(function() {	
	KTContactsAdd.init();
});