<?php 
include('../include/security.php');
include('../include/conn.php');
?>
<!DOCTYPE html>
<html lang="en" >
<head>
        <meta charset="utf-8"/>

        <title><?php echo $title;?> - Add Customer</title>
        <meta name="description" content="Add contact example">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <!--begin::Fonts -->
        <link rel="stylesheet" href="assets/css/bear/fonts.css?family=Poppins:300,400,500,600,700|Roboto:300,400,500,600,700">        <!--end::Fonts -->

        
                    <!--begin::Page Custom Styles(used by this page) -->
                             <link href="assets/css/bear/pages/wizard/wizard-1.css" rel="stylesheet" type="text/css" />
                        <!--end::Page Custom Styles -->
        
        <!--begin::Global Theme Styles(used by all pages) -->
                    <link href="assets/vendors/global/vendors.bundle.css" rel="stylesheet" type="text/css" />
                    <link href="assets/css/bear/style.bundle.css" rel="stylesheet" type="text/css" />
                <!--end::Global Theme Styles -->

        <!--begin::Layout Skins(used by all pages) -->
                <!--end::Layout Skins -->

        <link rel="shortcut icon" href="assets/media/logos/favicon.png" />
 
    </head>
    <!-- end::Head -->

    <!-- begin::Body -->
    <body  class="kt-quick-panel--right kt-demo-panel--right kt-offcanvas-panel--right kt-header--fixed kt-header-mobile--fixed kt-subheader--enabled kt-subheader--transparent kt-aside--enabled kt-aside--fixed kt-aside--minimize kt-page--loading"  >

       
    	<!-- begin:: Page -->
	
<!-- begin:: Header Mobile -->
<?php include("../include/header-mobile.php");?>	
<!-- end:: Header Mobile -->
	<div class="kt-grid kt-grid--hor kt-grid--root">
		<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--ver kt-page">
			<!-- begin:: Aside -->
<button class="kt-aside-close " id="kt_aside_close_btn"><i class="la la-close"></i></button>

<?php include("../include/leftside-menu.php");?>	
<div class="kt-aside-menu-overlay"></div>
<!-- end:: Aside -->
<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor kt-wrapper" id="kt_wrapper">
<!-- begin:: Header -->
<div id="kt_header" class="kt-header kt-grid kt-grid--ver  kt-header--fixed " >
			<!-- begin: Header Menu -->
<button class="kt-header-menu-wrapper-close" id="kt_header_menu_mobile_close_btn"><i class="la la-close"></i></button>
<?php include("../include/header-top-menu.php");?>	
<!-- end: Header Menu -->	
	<!-- begin:: Header Topbar -->
<div class="kt-header__topbar">
	<!--begin: Search -->
	<div class="kt-header__topbar-item kt-header__topbar-item--search">
		<div class="kt-header__topbar-wrapper">
			<div class="kt-quick-search kt-quick-search--inline kt-quick-search--result-compact" id="kt_quick_search_inline">
    <form method="get" class="kt-quick-search__form">
        <div class="input-group">
            <div class="input-group-prepend"><span class="input-group-text"><i class="flaticon2-search-1"></i></span></div>
            <input type="text" class="form-control kt-quick-search__input" placeholder="Search...">
            <div class="input-group-append"><span class="input-group-text"><i class="la la-close kt-quick-search__close" style="display: none;"></i></span></div>
        </div>
    </form>
    <div id="kt_quick_search_toggle" data-toggle="dropdown" data-offset="0px,10px"></div>
    <div class="dropdown-menu dropdown-menu-fit dropdown-menu-right dropdown-menu-anim dropdown-menu-lg">
        <div class="kt-quick-search__wrapper kt-scroll" data-scroll="true" data-height="300" data-mobile-height="200">

        </div>
    </div>
</div>
		</div>
	</div>
	<!--end: Search -->

	<!--begin: Notifications -->
	<?php include("../include/header-notifications.php");?>	
	<!--end: Notifications -->

	<!--begin: Quick actions -->
    <?php include("../include/header-top-right-quick-btn.php");?>
	<!--end: Quick actions -->



	<!--begin: User bar -->
	<?php include("../include/header-top-right.php");?>
	<!--end: User bar -->


</div>
<!-- end:: Header Topbar -->
</div>
<!-- end:: Header -->
<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">
											<!-- begin:: Content Head -->
<div class="kt-subheader   kt-grid__item" id="kt_subheader">
    <div class="kt-container  kt-container--fluid ">
        <div class="kt-subheader__main">
            
            <h3 class="kt-subheader__title">
                                    New Customer                           
            </h3>

            <span class="kt-subheader__separator kt-subheader__separator--v"></span>
            
            <div class="kt-subheader__group" id="kt_subheader_search">
                <span class="kt-subheader__desc" id="kt_subheader_total">
                                            Enter customer details and submit                                    </span>
                
                            </div>

                    </div>        
        <div class="kt-subheader__toolbar">

                            <a href="<?php echo $url;?>/customers/customers.php" class="btn btn-default btn-bold">
                    
                    Back                </a>
            
                     
                                        
                    </div>
    </div>
</div>
<!-- end:: Content Head -->					
					<!-- begin:: Content -->
	<div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">
		<div class="kt-portlet">
	<div class="kt-portlet__body kt-portlet__body--fit">
		<div class="kt-grid  kt-wizard-v1 kt-wizard-v1--white" id="kt_contacts_add" data-ktwizard-state="step-first">
			<div class="kt-grid__item">
				<!--begin: Form Wizard Nav -->
				<div class="kt-wizard-v1__nav">
					<div class="kt-wizard-v1__nav-items">
                        <!--doc: Replace A tag with SPAN tag to disable the step link click -->
						<a class="kt-wizard-v1__nav-item" href="#" data-ktwizard-type="step" data-ktwizard-state="current">
							<div class="kt-wizard-v1__nav-body">
								<div class="kt-wizard-v1__nav-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon kt-svg-icon--xl">
    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <polygon id="Shape" points="0 0 24 0 24 24 0 24"/>
        <path d="M18,8 L16,8 C15.4477153,8 15,7.55228475 15,7 C15,6.44771525 15.4477153,6 16,6 L18,6 L18,4 C18,3.44771525 18.4477153,3 19,3 C19.5522847,3 20,3.44771525 20,4 L20,6 L22,6 C22.5522847,6 23,6.44771525 23,7 C23,7.55228475 22.5522847,8 22,8 L20,8 L20,10 C20,10.5522847 19.5522847,11 19,11 C18.4477153,11 18,10.5522847 18,10 L18,8 Z M9,11 C6.790861,11 5,9.209139 5,7 C5,4.790861 6.790861,3 9,3 C11.209139,3 13,4.790861 13,7 C13,9.209139 11.209139,11 9,11 Z" id="Combined-Shape" fill="#000000" fill-rule="nonzero" opacity="0.3"/>
        <path d="M0.00065168429,20.1992055 C0.388258525,15.4265159 4.26191235,13 8.98334134,13 C13.7712164,13 17.7048837,15.2931929 17.9979143,20.2 C18.0095879,20.3954741 17.9979143,21 17.2466999,21 C13.541124,21 8.03472472,21 0.727502227,21 C0.476712155,21 -0.0204617505,20.45918 0.00065168429,20.1992055 Z" id="Mask-Copy" fill="#000000" fill-rule="nonzero"/>
    </g>
</svg>								</div>
								<div class="kt-wizard-v1__nav-label">
									1. Personal Information
								</div>
							</div>
                        </a>
						<a class="kt-wizard-v1__nav-item" href="#" data-ktwizard-type="step">
							<div class="kt-wizard-v1__nav-body">
								<div class="kt-wizard-v1__nav-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon kt-svg-icon--xl">
    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <rect id="bound" x="0" y="0" width="24" height="24"/>
        <path d="M4.875,20.75 C4.63541667,20.75 4.39583333,20.6541667 4.20416667,20.4625 L2.2875,18.5458333 C1.90416667,18.1625 1.90416667,17.5875 2.2875,17.2041667 C2.67083333,16.8208333 3.29375,16.8208333 3.62916667,17.2041667 L4.875,18.45 L8.0375,15.2875 C8.42083333,14.9041667 8.99583333,14.9041667 9.37916667,15.2875 C9.7625,15.6708333 9.7625,16.2458333 9.37916667,16.6291667 L5.54583333,20.4625 C5.35416667,20.6541667 5.11458333,20.75 4.875,20.75 Z" id="check" fill="#000000" fill-rule="nonzero" opacity="0.3"/>
        <path d="M12.9835977,18 C12.7263047,14.0909841 9.47412135,11 5.5,11 C4.98630124,11 4.48466491,11.0516454 4,11.1500272 L4,7 C4,5.8954305 4.8954305,5 6,5 L20,5 C21.1045695,5 22,5.8954305 22,7 L22,16 C22,17.1045695 21.1045695,18 20,18 L12.9835977,18 Z M19.1444251,6.83964668 L13,10.1481833 L6.85557487,6.83964668 C6.4908718,6.6432681 6.03602525,6.77972206 5.83964668,7.14442513 C5.6432681,7.5091282 5.77972206,7.96397475 6.14442513,8.16035332 L12.6444251,11.6603533 C12.8664074,11.7798822 13.1335926,11.7798822 13.3555749,11.6603533 L19.8555749,8.16035332 C20.2202779,7.96397475 20.3567319,7.5091282 20.1603533,7.14442513 C19.9639747,6.77972206 19.5091282,6.6432681 19.1444251,6.83964668 Z" id="Combined-Shape" fill="#000000"/>
    </g>
</svg>								</div>
								<div class="kt-wizard-v1__nav-label">
									2. Account Settings
								</div>
							</div>
						</a>
						<a class="kt-wizard-v1__nav-item" href="#" data-ktwizard-type="step">
							<div class="kt-wizard-v1__nav-body">
								<div class="kt-wizard-v1__nav-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon kt-svg-icon--xl">
    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <rect id="bound" x="0" y="0" width="24" height="24"/>
        <rect id="Rectangle-2" fill="#000000" opacity="0.3" x="2" y="2" width="10" height="12" rx="2"/>
        <path d="M4,6 L20,6 C21.1045695,6 22,6.8954305 22,8 L22,20 C22,21.1045695 21.1045695,22 20,22 L4,22 C2.8954305,22 2,21.1045695 2,20 L2,8 C2,6.8954305 2.8954305,6 4,6 Z M18,16 C19.1045695,16 20,15.1045695 20,14 C20,12.8954305 19.1045695,12 18,12 C16.8954305,12 16,12.8954305 16,14 C16,15.1045695 16.8954305,16 18,16 Z" id="Combined-Shape" fill="#000000"/>
    </g>
</svg>								</div>
								<div class="kt-wizard-v1__nav-label">
									3. Address Details
								</div>
							</div>
						</a>
						<a class="kt-wizard-v1__nav-item" href="#" data-ktwizard-type="step">
							<div class="kt-wizard-v1__nav-body">
								<div class="kt-wizard-v1__nav-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1" class="kt-svg-icon kt-svg-icon--xl">
    <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <rect id="bound" x="0" y="0" width="24" height="24"/>
        <path d="M13.2070325,4 C13.0721672,4.47683179 13,4.97998812 13,5.5 C13,8.53756612 15.4624339,11 18.5,11 C19.0200119,11 19.5231682,10.9278328 20,10.7929675 L20,17 C20,18.6568542 18.6568542,20 17,20 L7,20 C5.34314575,20 4,18.6568542 4,17 L4,7 C4,5.34314575 5.34314575,4 7,4 L13.2070325,4 Z" id="Combined-Shape" fill="#000000"/>
        <circle id="Oval" fill="#000000" opacity="0.3" cx="18.5" cy="5.5" r="2.5"/>
    </g>
</svg>								</div>
								<div class="kt-wizard-v1__nav-label">
									4. Review and Submit
								</div>
							</div>
						</a>						
					</div>
				</div>
				<!--end: Form Wizard Nav -->
			</div>
			<div class="kt-grid__item kt-grid__item--fluid kt-wizard-v1__wrapper">
				<!--begin: Form Wizard Form-->
                <form class="kt-form" id="kt_contacts_add_form" action="../controllers/customers.php?insert=<?php echo base64_encode('customer');?>" enctype="multipart/form-data" method="POST">
                    <!--begin: Form Wizard Step 1-->
                    <div class="kt-wizard-v1__content" data-ktwizard-type="step-content" data-ktwizard-state="current">
                        <div class="kt-heading kt-heading--md">Customers's Profile Details:</div>
                        <div class="kt-section kt-section--first">
                            <div class="kt-wizard-v1__form">
                                <div class="row">
                                    <div class="col-xl-12">
                                        <div class="kt-section__body">
                                            <div class="form-group row">
                                                <label class="col-xl-3 col-lg-3 col-form-label">Picture</label>
                                                <div class="col-lg-9 col-xl-6">
                                                    <div class="kt-avatar kt-avatar--outline" id="kt_contacts_add_avatar">
                                                        <div class="kt-avatar__holder" style="background-image: url(assets/media/users/300_10.jpg)"></div>
                                                        <label class="kt-avatar__upload" data-toggle="kt-tooltip" title="" data-original-title="Change Picture">
                                                            <i class="fa fa-pen"></i>
                                                            <input type="file" id="customer_picture" name="customer_picture">
                                                        </label>
                                                        <span class="kt-avatar__cancel" data-toggle="kt-tooltip" title="" data-original-title="Cancel Picture">
                                                            <i class="fa fa-times"></i>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-xl-3 col-lg-3 col-form-label">First Name</label>
                                                <div class="col-lg-9 col-xl-9">
                                                    <input class="form-control" type="text" placeholder="Hammad" id="customer_first_name" name="customer_first_name" required>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-xl-3 col-lg-3 col-form-label">Last Name</label>
                                                <div class="col-lg-9 col-xl-9">
                                                    <input class="form-control" type="text" placeholder="Pervaiz" id="customer_last_name" name="customer_last_name" required>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-xl-3 col-lg-3 col-form-label">Company Name</label>
                                                <div class="col-lg-9 col-xl-9">
                                                    <input class="form-control" type="text"  placeholder="Bearplex" id="customer_company" name="customer_company" required>
                                                    
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-xl-3 col-lg-3 col-form-label">Contact Phone</label>
                                                <div class="col-lg-9 col-xl-9">
                                                    <div class="input-group">
                                                        <div class="input-group-prepend"><span class="input-group-text"><i class="la la-phone"></i></span></div>
                                                        <input type="text" class="form-control" placeholder="+45678967456" aria-describedby="basic-addon1" id="customer_phone" name="customer_phone" required>
                                                    </div>
                                                    
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-xl-3 col-lg-3 col-form-label">Email Address</label>
                                                <div class="col-lg-9 col-xl-9">
                                                    <div class="input-group">
                                                        <div class="input-group-prepend"><span class="input-group-text"><i class="la la-at"></i></span></div>
                                                        <input type="text" class="form-control" placeholder="hello@bearplex.com" aria-describedby="basic-addon1" id="customer_email" name="customer_email" required>
                                                    </div>
													<span class="form-text text-muted">We'll never share your email with anyone else.</span>
                                                </div>
                                            </div>
                                            <div class="form-group form-group-last row">
                                                <label class="col-xl-3 col-lg-3 col-form-label">Company Site</label>
                                                <div class="col-lg-9 col-xl-9">
                                                    <div class="input-group">
                                                        <input type="url" class="form-control" placeholder="http://bearplex.com" id="customer_website" name="customer_website">
                                                        <div class="input-group-append"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end: Form Wizard Step 1-->

                    <!--begin: Form Wizard Step 2-->
                    <div class="kt-wizard-v1__content" data-ktwizard-type="step-content">                           
                        <div class="kt-section kt-section--first">
                            <div class="kt-wizard-v1__form">
                                <div class="row">
                                    <div class="col-xl-12">
                                        <div class="kt-section__body">
                                            <div class="form-group row">                                                     
                                                <div class="col-lg-9 col-xl-6">
                                                    <h3 class="kt-section__title kt-section__title-md">Customers's Account Details</h3>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-xl-3 col-lg-3 col-form-label">Username</label>
                                                <div class="col-lg-9 col-xl-9">
                                                    <input class="form-control" type="text" placeholder="bearplex" id="customer_username" name="customer_username">
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-xl-3 col-lg-3 col-form-label">Password</label>
                                                <div class="col-lg-9 col-xl-9">
                                                    <input class="form-control" type="password" placeholder="********" id="customer_password" name="customer_password">
                                                </div>
                                            </div>
                                           
										   
											
											<div class="form-group form-group-last row">
                                                <label class="col-xl-3 col-lg-3 col-form-label">Communication</label>
                                                <div class="col-lg-9 col-xl-6">
                                                    <div class="kt-checkbox-inline">
                                                        <label class="kt-checkbox">
                                                            <input type="radio"  id="customer_comm_channel1" name="customer_comm_channel" value="Email"> Email
                                                            <span></span>
                                                        </label>
                                                        <label class="kt-checkbox">
                                                            <input type="radio"  id="customer_comm_channel2" name="customer_comm_channel" value="SMS"> SMS
                                                            <span></span>
                                                        </label>
                                                        <label class="kt-checkbox">
                                                            <input type="radio" id="customer_comm_channel3" name="customer_comm_channel" value="Phone"> Phone
                                                            <span></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                        <div class="kt-separator kt-separator--border-dashed kt-separator--portlet-fit kt-separator--space-lg"></div>

                                            <div class="form-group row">                                                  
                                                <div class="col-lg-9 col-xl-6">
                                                    <h3 class="kt-section__title kt-section__title-md">Invoice Settings</h3>
                                                </div>
                                            </div>
                                              <div class="form-group row">
                                                <label class="col-xl-3 col-lg-3 col-form-label">Currency</label>
                                                <div class="col-lg-9 col-xl-9">
                                                    <select id="customer_currency" name="customer_currency" class="form-control">
														<option value="USD" selected="selected">United States Dollars</option>
														<option value="EUR">Euro</option>
														<option value="GBP">United Kingdom Pounds</option>
														<option value="DZD">Algeria Dinars</option>
														<option value="ARP">Argentina Pesos</option>
														<option value="AUD">Australia Dollars</option>
														<option value="ATS">Austria Schillings</option>
														<option value="BSD">Bahamas Dollars</option>
														<option value="BBD">Barbados Dollars</option>
														<option value="BEF">Belgium Francs</option>
														<option value="BMD">Bermuda Dollars</option>
														<option value="BRR">Brazil Real</option>
														<option value="BGL">Bulgaria Lev</option>
														<option value="CAD">Canada Dollars</option>
														<option value="CLP">Chile Pesos</option>
														<option value="CNY">China Yuan Renmimbi</option>
														<option value="CYP">Cyprus Pounds</option>
														<option value="CSK">Czech Republic Koruna</option>
														<option value="DKK">Denmark Kroner</option>
														<option value="NLG">Dutch Guilders</option>
														<option value="XCD">Eastern Caribbean Dollars</option>
														<option value="EGP">Egypt Pounds</option>
														<option value="FJD">Fiji Dollars</option>
														<option value="FIM">Finland Markka</option>
														<option value="FRF">France Francs</option>
														<option value="DEM">Germany Deutsche Marks</option>
														<option value="XAU">Gold Ounces</option>
														<option value="GRD">Greece Drachmas</option>
														<option value="HKD">Hong Kong Dollars</option>
														<option value="HUF">Hungary Forint</option>
														<option value="ISK">Iceland Krona</option>
														<option value="INR">India Rupees</option>
														<option value="IDR">Indonesia Rupiah</option>
														<option value="IEP">Ireland Punt</option>
														<option value="ILS">Israel New Shekels</option>
														<option value="ITL">Italy Lira</option>
														<option value="JMD">Jamaica Dollars</option>
														<option value="JPY">Japan Yen</option>
														<option value="JOD">Jordan Dinar</option>
														<option value="KRW">Korea (South) Won</option>
														<option value="LBP">Lebanon Pounds</option>
														<option value="LUF">Luxembourg Francs</option>
														<option value="MYR">Malaysia Ringgit</option>
														<option value="MXP">Mexico Pesos</option>
														<option value="NLG">Netherlands Guilders</option>
														<option value="NZD">New Zealand Dollars</option>
														<option value="NOK">Norway Kroner</option>
														<option value="PKR">Pakistan Rupees</option>
														<option value="XPD">Palladium Ounces</option>
														<option value="PHP">Philippines Pesos</option>
														<option value="XPT">Platinum Ounces</option>
														<option value="PLZ">Poland Zloty</option>
														<option value="PTE">Portugal Escudo</option>
														<option value="ROL">Romania Leu</option>
														<option value="RUR">Russia Rubles</option>
														<option value="SAR">Saudi Arabia Riyal</option>
														<option value="XAG">Silver Ounces</option>
														<option value="SGD">Singapore Dollars</option>
														<option value="SKK">Slovakia Koruna</option>
														<option value="ZAR">South Africa Rand</option>
														<option value="KRW">South Korea Won</option>
														<option value="ESP">Spain Pesetas</option>
														<option value="XDR">Special Drawing Right (IMF)</option>
														<option value="SDD">Sudan Dinar</option>
														<option value="SEK">Sweden Krona</option>
														<option value="CHF">Switzerland Francs</option>
														<option value="TWD">Taiwan Dollars</option>
														<option value="THB">Thailand Baht</option>
														<option value="TTD">Trinidad and Tobago Dollars</option>
														<option value="TRL">Turkey Lira</option>
														<option value="VEB">Venezuela Bolivar</option>
														<option value="ZMK">Zambia Kwacha</option>
														<option value="EUR">Euro</option>
														<option value="XCD">Eastern Caribbean Dollars</option>
														<option value="XDR">Special Drawing Right (IMF)</option>
														<option value="XAG">Silver Ounces</option>
														<option value="XAU">Gold Ounces</option>
														<option value="XPD">Palladium Ounces</option>
														<option value="XPT">Platinum Ounces</option>
													</select>
                                               
											   </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-xl-3 col-lg-3 col-form-label">Invoicing Date</label>
                                                <div class="col-lg-9 col-xl-9">
                                                    <input class="form-control" type="text" placeholder="Invoicing Date" id="customer_invoice_date" name="customer_invoice_date">
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end: Form Wizard Step 2-->

                    <!--begin: Form Wizard Step 3-->
                    <div class="kt-wizard-v1__content" data-ktwizard-type="step-content">
                        <div class="kt-heading kt-heading--md">Setup Your Address</div>
                        <div class="kt-form__section kt-form__section--first">
                            <div class="kt-wizard-v1__form">
                                <div class="form-group">
                                    <label>Address</label>
                                    <textarea class="form-control"  id="customer_address" name="customer_address" placeholder="Address Line 1"></textarea>
                                    <span class="form-text text-muted">Please enter your Address.</span>
                                </div>
                               
                                <div class="row">
                                    <div class="col-xl-6">
                                        <div class="form-group">
                                            <label>Postcode</label>
                                            <input type="text" class="form-control" id="customer_postal_code" name="customer_postal_code" placeholder="54000">
                                            <span class="form-text text-muted">Please enter your Postcode.</span>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="form-group">
                                            <label>City</label>
                                            <input type="text" class="form-control" id="customer_city" name="customer_city" placeholder="Lahore">
                                            <span class="form-text text-muted">Please enter your City.</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xl-6">
                                        <div class="form-group">
                                            <label>State</label>
                                            <input type="text" class="form-control" id="customer_state" name="customer_state" placeholder="Punjab" >
                                            <span class="form-text text-muted">Please enter your State.</span>
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class="form-group">
                                        <label>Country:</label>
                                        <select id="customer_country" name="customer_country" class="form-control">
                                            <option value="">Select</option>
                                            <option value="AF">Afghanistan</option>
                                            <option value="AX">Åland Islands</option>
                                            <option value="AL">Albania</option>
                                            <option value="DZ">Algeria</option>
                                            <option value="AS">American Samoa</option>
                                            <option value="AD">Andorra</option>
                                            <option value="AO">Angola</option>
                                            <option value="AI">Anguilla</option>
                                            <option value="AQ">Antarctica</option>
                                            <option value="AG">Antigua and Barbuda</option>
                                            <option value="AR">Argentina</option>
                                            <option value="AM">Armenia</option>
                                            <option value="AW">Aruba</option>
                                            <option value="AU">Australia</option>
                                            <option value="AT">Austria</option>
                                            <option value="AZ">Azerbaijan</option>
                                            <option value="BS">Bahamas</option>
                                            <option value="BH">Bahrain</option>
                                            <option value="BD">Bangladesh</option>
                                            <option value="BB">Barbados</option>
                                            <option value="BY">Belarus</option>
                                            <option value="BE">Belgium</option>
                                            <option value="BZ">Belize</option>
                                            <option value="BJ">Benin</option>
                                            <option value="BM">Bermuda</option>
                                            <option value="BT">Bhutan</option>
                                            <option value="BO">Bolivia, Plurinational State of</option>
                                            <option value="BQ">Bonaire, Sint Eustatius and Saba</option>
                                            <option value="BA">Bosnia and Herzegovina</option>
                                            <option value="BW">Botswana</option>
                                            <option value="BV">Bouvet Island</option>
                                            <option value="BR">Brazil</option>
                                            <option value="IO">British Indian Ocean Territory</option>
                                            <option value="BN">Brunei Darussalam</option>
                                            <option value="BG">Bulgaria</option>
                                            <option value="BF">Burkina Faso</option>
                                            <option value="BI">Burundi</option>
                                            <option value="KH">Cambodia</option>
                                            <option value="CM">Cameroon</option>
                                            <option value="CA">Canada</option>
                                            <option value="CV">Cape Verde</option>
                                            <option value="KY">Cayman Islands</option>
                                            <option value="CF">Central African Republic</option>
                                            <option value="TD">Chad</option>
                                            <option value="CL">Chile</option>
                                            <option value="CN">China</option>
                                            <option value="CX">Christmas Island</option>
                                            <option value="CC">Cocos (Keeling) Islands</option>
                                            <option value="CO">Colombia</option>
                                            <option value="KM">Comoros</option>
                                            <option value="CG">Congo</option>
                                            <option value="CD">Congo, the Democratic Republic of the</option>
                                            <option value="CK">Cook Islands</option>
                                            <option value="CR">Costa Rica</option>
                                            <option value="CI">Côte d'Ivoire</option>
                                            <option value="HR">Croatia</option>
                                            <option value="CU">Cuba</option>
                                            <option value="CW">Curaçao</option>
                                            <option value="CY">Cyprus</option>
                                            <option value="CZ">Czech Republic</option>
                                            <option value="DK">Denmark</option>
                                            <option value="DJ">Djibouti</option>
                                            <option value="DM">Dominica</option>
                                            <option value="DO">Dominican Republic</option>
                                            <option value="EC">Ecuador</option>
                                            <option value="EG">Egypt</option>
                                            <option value="SV">El Salvador</option>
                                            <option value="GQ">Equatorial Guinea</option>
                                            <option value="ER">Eritrea</option>
                                            <option value="EE">Estonia</option>
                                            <option value="ET">Ethiopia</option>
                                            <option value="FK">Falkland Islands (Malvinas)</option>
                                            <option value="FO">Faroe Islands</option>
                                            <option value="FJ">Fiji</option>
                                            <option value="FI">Finland</option>
                                            <option value="FR">France</option>
                                            <option value="GF">French Guiana</option>
                                            <option value="PF">French Polynesia</option>
                                            <option value="TF">French Southern Territories</option>
                                            <option value="GA">Gabon</option>
                                            <option value="GM">Gambia</option>
                                            <option value="GE">Georgia</option>
                                            <option value="DE">Germany</option>
                                            <option value="GH">Ghana</option>
                                            <option value="GI">Gibraltar</option>
                                            <option value="GR">Greece</option>
                                            <option value="GL">Greenland</option>
                                            <option value="GD">Grenada</option>
                                            <option value="GP">Guadeloupe</option>
                                            <option value="GU">Guam</option>
                                            <option value="GT">Guatemala</option>
                                            <option value="GG">Guernsey</option>
                                            <option value="GN">Guinea</option>
                                            <option value="GW">Guinea-Bissau</option>
                                            <option value="GY">Guyana</option>
                                            <option value="HT">Haiti</option>
                                            <option value="HM">Heard Island and McDonald Islands</option>
                                            <option value="VA">Holy See (Vatican City State)</option>
                                            <option value="HN">Honduras</option>
                                            <option value="HK">Hong Kong</option>
                                            <option value="HU">Hungary</option>
                                            <option value="IS">Iceland</option>
                                            <option value="IN">India</option>
                                            <option value="ID">Indonesia</option>
                                            <option value="IR">Iran, Islamic Republic of</option>
                                            <option value="IQ">Iraq</option>
                                            <option value="IE">Ireland</option>
                                            <option value="IM">Isle of Man</option>
                                            <option value="IL">Israel</option>
                                            <option value="IT">Italy</option>
                                            <option value="JM">Jamaica</option>
                                            <option value="JP">Japan</option>
                                            <option value="JE">Jersey</option>
                                            <option value="JO">Jordan</option>
                                            <option value="KZ">Kazakhstan</option>
                                            <option value="KE">Kenya</option>
                                            <option value="KI">Kiribati</option>
                                            <option value="KP">Korea, Democratic People's Republic of</option>
                                            <option value="KR">Korea, Republic of</option>
                                            <option value="KW">Kuwait</option>
                                            <option value="KG">Kyrgyzstan</option>
                                            <option value="LA">Lao People's Democratic Republic</option>
                                            <option value="LV">Latvia</option>
                                            <option value="LB">Lebanon</option>
                                            <option value="LS">Lesotho</option>
                                            <option value="LR">Liberia</option>
                                            <option value="LY">Libya</option>
                                            <option value="LI">Liechtenstein</option>
                                            <option value="LT">Lithuania</option>
                                            <option value="LU">Luxembourg</option>
                                            <option value="MO">Macao</option>
                                            <option value="MK">Macedonia, the former Yugoslav Republic of</option>
                                            <option value="MG">Madagascar</option>
                                            <option value="MW">Malawi</option>
                                            <option value="MY">Malaysia</option>
                                            <option value="MV">Maldives</option>
                                            <option value="ML">Mali</option>
                                            <option value="MT">Malta</option>
                                            <option value="MH">Marshall Islands</option>
                                            <option value="MQ">Martinique</option>
                                            <option value="MR">Mauritania</option>
                                            <option value="MU">Mauritius</option>
                                            <option value="YT">Mayotte</option>
                                            <option value="MX">Mexico</option>
                                            <option value="FM">Micronesia, Federated States of</option>
                                            <option value="MD">Moldova, Republic of</option>
                                            <option value="MC">Monaco</option>
                                            <option value="MN">Mongolia</option>
                                            <option value="ME">Montenegro</option>
                                            <option value="MS">Montserrat</option>
                                            <option value="MA">Morocco</option>
                                            <option value="MZ">Mozambique</option>
                                            <option value="MM">Myanmar</option>
                                            <option value="NA">Namibia</option>
                                            <option value="NR">Nauru</option>
                                            <option value="NP">Nepal</option>
                                            <option value="NL">Netherlands</option>
                                            <option value="NC">New Caledonia</option>
                                            <option value="NZ">New Zealand</option>
                                            <option value="NI">Nicaragua</option>
                                            <option value="NE">Niger</option>
                                            <option value="NG">Nigeria</option>
                                            <option value="NU">Niue</option>
                                            <option value="NF">Norfolk Island</option>
                                            <option value="MP">Northern Mariana Islands</option>
                                            <option value="NO">Norway</option>
                                            <option value="OM">Oman</option>
                                            <option value="PK">Pakistan</option>
                                            <option value="PW">Palau</option>
                                            <option value="PS">Palestinian Territory, Occupied</option>
                                            <option value="PA">Panama</option>
                                            <option value="PG">Papua New Guinea</option>
                                            <option value="PY">Paraguay</option>
                                            <option value="PE">Peru</option>
                                            <option value="PH">Philippines</option>
                                            <option value="PN">Pitcairn</option>
                                            <option value="PL">Poland</option>
                                            <option value="PT">Portugal</option>
                                            <option value="PR">Puerto Rico</option>
                                            <option value="QA">Qatar</option>
                                            <option value="RE">Réunion</option>
                                            <option value="RO">Romania</option>
                                            <option value="RU">Russian Federation</option>
                                            <option value="RW">Rwanda</option>
                                            <option value="BL">Saint Barthélemy</option>
                                            <option value="SH">Saint Helena, Ascension and Tristan da Cunha</option>
                                            <option value="KN">Saint Kitts and Nevis</option>
                                            <option value="LC">Saint Lucia</option>
                                            <option value="MF">Saint Martin (French part)</option>
                                            <option value="PM">Saint Pierre and Miquelon</option>
                                            <option value="VC">Saint Vincent and the Grenadines</option>
                                            <option value="WS">Samoa</option>
                                            <option value="SM">San Marino</option>
                                            <option value="ST">Sao Tome and Principe</option>
                                            <option value="SA">Saudi Arabia</option>
                                            <option value="SN">Senegal</option>
                                            <option value="RS">Serbia</option>
                                            <option value="SC">Seychelles</option>
                                            <option value="SL">Sierra Leone</option>
                                            <option value="SG">Singapore</option>
                                            <option value="SX">Sint Maarten (Dutch part)</option>
                                            <option value="SK">Slovakia</option>
                                            <option value="SI">Slovenia</option>
                                            <option value="SB">Solomon Islands</option>
                                            <option value="SO">Somalia</option>
                                            <option value="ZA">South Africa</option>
                                            <option value="GS">South Georgia and the South Sandwich Islands</option>
                                            <option value="SS">South Sudan</option>
                                            <option value="ES">Spain</option>
                                            <option value="LK">Sri Lanka</option>
                                            <option value="SD">Sudan</option>
                                            <option value="SR">Suriname</option>
                                            <option value="SJ">Svalbard and Jan Mayen</option>
                                            <option value="SZ">Swaziland</option>
                                            <option value="SE">Sweden</option>
                                            <option value="CH">Switzerland</option>
                                            <option value="SY">Syrian Arab Republic</option>
                                            <option value="TW">Taiwan, Province of China</option>
                                            <option value="TJ">Tajikistan</option>
                                            <option value="TZ">Tanzania, United Republic of</option>
                                            <option value="TH">Thailand</option>
                                            <option value="TL">Timor-Leste</option>
                                            <option value="TG">Togo</option>
                                            <option value="TK">Tokelau</option>
                                            <option value="TO">Tonga</option>
                                            <option value="TT">Trinidad and Tobago</option>
                                            <option value="TN">Tunisia</option>
                                            <option value="TR">Turkey</option>
                                            <option value="TM">Turkmenistan</option>
                                            <option value="TC">Turks and Caicos Islands</option>
                                            <option value="TV">Tuvalu</option>
                                            <option value="UG">Uganda</option>
                                            <option value="UA">Ukraine</option>
                                            <option value="AE">United Arab Emirates</option>
                                            <option value="GB">United Kingdom</option>
                                            <option value="US">United States</option>
                                            <option value="UM">United States Minor Outlying Islands</option>
                                            <option value="UY">Uruguay</option>
                                            <option value="UZ">Uzbekistan</option>
                                            <option value="VU">Vanuatu</option>
                                            <option value="VE">Venezuela, Bolivarian Republic of</option>
                                            <option value="VN">Viet Nam</option>
                                            <option value="VG">Virgin Islands, British</option>
                                            <option value="VI">Virgin Islands, U.S.</option>
                                            <option value="WF">Wallis and Futuna</option>
                                            <option value="EH">Western Sahara</option>
                                            <option value="YE">Yemen</option>
                                            <option value="ZM">Zambia</option>
                                            <option value="ZW">Zimbabwe</option>
                                        </select>
                                   
								   </div>
                                    </div>
                                </div>
                            </div>
                        
						</div>
                    </div>
                    
					<!--end: Form Wizard Step 3-->

                    <!--begin: Form Wizard Step 4-->
                    <div class="kt-wizard-v1__content" data-ktwizard-type="step-content">
                        <div class="kt-heading kt-heading--md">Review your Details and Submit</div>
                        <div class="kt-form__section kt-form__section--first">
                            <div class="kt-wizard-v1__review" id="html_review">
                                <div class="kt-wizard-v1__review-item">
                                    <div class="kt-wizard-v1__review-title">
                                        Your Account Details
                                    </div>
                                    <div class="kt-wizard-v1__review-content">
                                        John Wick
                                        <br/> Phone: +61412345678
                                        <br/> Email: johnwick@reeves.com
                                    </div>
                                </div>
                                <div class="kt-wizard-v1__review-item">
                                    <div class="kt-wizard-v1__review-title">
                                        Your Address Details
                                    </div>
                                    <div class="kt-wizard-v1__review-content">
                                        Address Line 1
                                        <br/> Address Line 2
                                        <br/> Melbourne 3000, VIC, Australia
                                    </div>
                                </div>
                                <div class="kt-wizard-v1__review-item">
                                    <div class="kt-wizard-v1__review-title">
                                        Payment Details
                                    </div>
                                    <div class="kt-wizard-v1__review-content">
                                        Card Number: xxxx xxxx xxxx 1111
                                        <br/> Card Name: John Wick
                                        <br/> Card Expiry: 01/21
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--end: Form Wizard Step 4-->

                    <!--begin: Form Actions -->
                    <div class="kt-form__actions">
                        <div class="btn btn-secondary btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u" data-ktwizard-type="action-prev">
                            Previous
                        </div>
                        <div class="btn btn-success btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u" data-ktwizard-type="action-submit">
                            Submit
                        </div>
                        <div class="btn btn-brand btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u" data-ktwizard-type="action-next">
                            Next Step
                        </div>
                    </div>
                    <!--end: Form Actions -->
                </form>
                <!--end: Form Wizard Form-->
			</div>
		</div>
	</div>
</div>	</div>
<!-- end:: Content -->				</div>	
				
<!-- begin:: Footer -->
	<?php include("../include/footer.php");?>
<!-- end:: Footer -->			</div>
		</div>
	</div>
	
<!-- end:: Page -->
<?php include("../include/footer-quick-modal.php");?>

    
    <!-- begin::Scrolltop -->
<div id="kt_scrolltop" class="kt-scrolltop">
		<i class="fa fa-arrow-up"></i>
</div>
<!-- end::Scrolltop -->


				
							</div>
                        </div>
                    </div>
        
                </div>
            </div>
        </div>
    </div>
</div>
<!--ENd:: Chat-->
        <!-- begin::Global Config(global config for global JS sciprts) -->
        <script>
            var KTAppOptions = {"colors":{"state":{"brand":"#22b9ff","light":"#ffffff","dark":"#282a3c","primary":"#5867dd","success":"#34bfa3","info":"#36a3f7","warning":"#ffb822","danger":"#fd3995"},"base":{"label":["#c5cbe3","#a1a8c3","#3d4465","#3e4466"],"shape":["#f0f3ff","#d9dffa","#afb4d4","#646c9a"]}}};
        </script>
        <!-- end::Global Config -->


    	    	<!--begin::Global Theme Bundle(used by all pages) -->
    	    	   <script src="assets/vendors/global/vendors.bundle.js" type="text/javascript"></script>
		    	   <script src="assets/js/bear/scripts.bundle.js" type="text/javascript"></script>
				<!--end::Global Theme Bundle -->

        
                    <!--begin::Page Scripts(used by this page) -->
                            <script src="assets/js/bear/pages/custom/contacts/add-contact.js" type="text/javascript"></script>
                        <!--end::Page Scripts -->
							<script src="../assets/js/bear/pages/widgets/bootstrap-datepicker.js" type="text/javascript"></script>
							
                        <!--end::Page Scripts -->
            </body>
    <!-- end::Body -->

</html>
