<?php 
include('../include/security.php');
include('../include/conn.php');
$currencies= mysqli_query($db,"SELECT * FROM tblcurrencies order by currency_id desc");
$total_currencies = mysqli_num_rows($currencies);

?>
<!DOCTYPE html>
<html lang="en" >
<head>
        <meta charset="utf-8"/>

        <title><?php echo $title;?> - Currencies</title>
        <meta name="description" content="Currencies Listing">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <!--begin::Fonts -->
        <link rel="stylesheet" href="assets/css/bear/fonts.css?family=Poppins:300,400,500,600,700|Roboto:300,400,500,600,700">        <!--end::Fonts -->

        
        
        <!--begin::Global Theme Styles(used by all pages) -->
                    <link href="assets/vendors/global/vendors.bundle.css" rel="stylesheet" type="text/css" />
                    <link href="assets/css/bear/style.bundle.css" rel="stylesheet" type="text/css" />
        <!--end::Global Theme Styles -->

        <!--begin::Layout Skins(used by all pages) -->
                <!--end::Layout Skins -->

        <link rel="shortcut icon" href="assets/media/logos/favicon.png" />
        
        
    </head>
    <!-- end::Head -->

    <!-- begin::Body -->
    <body  class="kt-quick-panel--right kt-demo-panel--right kt-offcanvas-panel--right kt-header--fixed kt-header-mobile--fixed kt-subheader--enabled kt-subheader--transparent kt-aside--enabled kt-aside--fixed kt-aside--minimize kt-page--loading"  >

       
    	<!-- begin:: Page -->
	
<!-- begin:: Header Mobile -->
<?php include("../include/header-mobile.php");?>	
<!-- end:: Header Mobile -->
	<div class="kt-grid kt-grid--hor kt-grid--root">
		<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--ver kt-page">
			<!-- begin:: Aside -->
<button class="kt-aside-close " id="kt_aside_close_btn"><i class="la la-close"></i></button>

<?php include("../include/leftside-menu.php");?>	
<div class="kt-aside-menu-overlay"></div>
<!-- end:: Aside -->
<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor kt-wrapper" id="kt_wrapper">
<!-- begin:: Header -->
<div id="kt_header" class="kt-header kt-grid kt-grid--ver  kt-header--fixed " >
			<!-- begin: Header Menu -->
<button class="kt-header-menu-wrapper-close" id="kt_header_menu_mobile_close_btn"><i class="la la-close"></i></button>
<?php include("../include/header-top-menu.php");?>	
<!-- end: Header Menu -->	
	<!-- begin:: Header Topbar -->
<div class="kt-header__topbar">
	<!--begin: Search -->
	<div class="kt-header__topbar-item kt-header__topbar-item--search">
		<div class="kt-header__topbar-wrapper">
			<div class="kt-quick-search kt-quick-search--inline kt-quick-search--result-compact" id="kt_quick_search_inline">
    <form method="get" class="kt-quick-search__form">
        <div class="input-group">
            <div class="input-group-prepend"><span class="input-group-text"><i class="flaticon2-search-1"></i></span></div>
            <input type="text" class="form-control kt-quick-search__input" placeholder="Search...">
            <div class="input-group-append"><span class="input-group-text"><i class="la la-close kt-quick-search__close" style="display: none;"></i></span></div>
        </div>
    </form>
    <div id="kt_quick_search_toggle" data-toggle="dropdown" data-offset="0px,10px"></div>
    <div class="dropdown-menu dropdown-menu-fit dropdown-menu-right dropdown-menu-anim dropdown-menu-lg">
        <div class="kt-quick-search__wrapper kt-scroll" data-scroll="true" data-height="300" data-mobile-height="200">

        </div>
    </div>
</div>
		</div>
	</div>
	<!--end: Search -->

	<!--begin: Notifications -->
	<?php include("../include/header-notifications.php");?>	
	<!--end: Notifications -->

	<!--begin: Quick actions -->
    <?php include("../include/header-top-right-quick-btn.php");?>
	<!--end: Quick actions -->



	<!--begin: User bar -->
	<?php include("../include/header-top-right.php");?>
	<!--end: User bar -->


</div>
<!-- end:: Header Topbar -->
</div>
<!-- end:: Header -->
				<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">
											<!-- begin:: Content Head -->
<div class="kt-subheader   kt-grid__item" id="kt_subheader">
    <div class="kt-container  kt-container--fluid ">
        <div class="kt-subheader__main">
            
            <h3 class="kt-subheader__title">
                                    Currencies                           
            </h3>

            <span class="kt-subheader__separator kt-subheader__separator--v"></span>
            
            <div class="kt-subheader__group" id="kt_subheader_search">
                <span class="kt-subheader__desc" id="kt_subheader_total">
                                            <?php echo $total_currencies;?> Total                                    </span>
                
                                
								
							</div>

                          
						  
					</div>        
        <div class="kt-subheader__toolbar">

                          
            
                                                <a href="<?php echo $url;?>/administration/add-currency.php" class="btn btn-label-brand btn-bold">
                        
                        Add Currency                    </a>
                                        
                        
					</div>
    </div>
</div>
<!-- end:: Content Head -->					
					<!-- begin:: Content -->
	<div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">


<div class="kt-portlet kt-portlet--mobile">


	<div class="kt-portlet__body">
		<!--begin: Search Form -->
        <div class="kt-form kt-form--label-right kt-margin-t-20 kt-margin-b-10">
	<div class="row align-items-center">
		<div class="col-xl-8 order-2 order-xl-1">
			<div class="row align-items-center">				
				<div class="col-md-4 kt-margin-b-20-tablet-and-mobile">
					<div class="kt-input-icon kt-input-icon--left">
						<input type="text" class="form-control" placeholder="Search..." id="generalSearch">
						<span class="kt-input-icon__icon kt-input-icon__icon--left">
							<span><i class="la la-search"></i></span>
						</span>
					</div>
				</div>
                				

                			</div>
		</div>
		
	</div>
</div>		<!--end: Search Form -->
	</div>
	<div class="kt-portlet__body kt-portlet__body--fit">
		<!--begin: Datatable -->
		<table class="kt-datatable" id="html_table" width="100%">
			<thead>
			<tr>
				
                <th>Full Name</th>
				<th>Short Name</th>
				<th>Current Rate</th>
				<th>Status</th>
                <th>Action</th>

			</tr>
			</thead>
			<tbody>
			<?php 
			   while($currency = mysqli_fetch_array($currencies)){  	
		    ?>
			<tr>
                <td><?php echo $currency['currency_name'];?></td>
                <td><?php echo $currency['currency_short_name'];?></td>
                <td><?php echo $currency['currency_rate'];?></td>
				<td>
				<?php if($currency['currency_status']=='Active'){?>
				<span class="kt-font-bold kt-font-success"><?php echo $currency['currency_status'];?></span>
				<?php }elseif($currency['currency_status']=='Inactive'){?>
				<span class="kt-font-bold kt-font-danger"><?php echo $currency['currency_status'];?></span>
				<?php } ?>
				</td>
				<td>
				        <a href="edit-currency.php?id=<?php echo $currency['currency_id'];?>" class="btn btn-sm btn-clean btn-icon btn-icon-md" title="Edit">
							<i class="la la-edit"></i></a>
							
						<a href="javascript:;" class="btn btn-sm btn-clean btn-icon btn-icon-md" title="Delete">
							<i class="la la-trash"></i></a>
				</td>
			</tr>
			
			<?php } ?>	
			
			</tbody>
		
		
		
		</table>
		<!--end: Datatable -->
	</div>
</div>	</div>


<!-- end:: Content -->				</div>	
				
				<!-- begin:: Footer -->
<?php include("../include/footer.php");?>
<!-- end:: Footer -->			</div>
		</div>
	</div>
	
<!-- end:: Page -->

<?php include("../include/footer-quick-modal.php");?>
    
    <!-- begin::Scrolltop -->
<div id="kt_scrolltop" class="kt-scrolltop">
		<i class="fa fa-arrow-up"></i>
</div>
<!-- end::Scrolltop -->


        

						   </div>
                        </div>
                    </div>
                 
                </div>
            </div>
        </div>
    </div>
</div>
<!--ENd:: Chat-->
        <!-- begin::Global Config(global config for global JS sciprts) -->
        <script>
            var KTAppOptions = {"colors":{"state":{"brand":"#22b9ff","light":"#ffffff","dark":"#282a3c","primary":"#5867dd","success":"#34bfa3","info":"#36a3f7","warning":"#ffb822","danger":"#fd3995"},"base":{"label":["#c5cbe3","#a1a8c3","#3d4465","#3e4466"],"shape":["#f0f3ff","#d9dffa","#afb4d4","#646c9a"]}}};
        </script>
        <!-- end::Global Config -->

    	<!--begin::Global Theme Bundle(used by all pages) -->
    	    	   <script src="assets/vendors/global/vendors.bundle.js" type="text/javascript"></script>
		    	   <script src="assets/js/bear/scripts.bundle.js" type="text/javascript"></script>
				<!--end::Global Theme Bundle -->
                   
  
                    <!--begin::Page Scripts(used by this page) -->
                    <script src="assets/js/bear/pages/custom/contacts/html-table.js" type="text/javascript"></script>    
                    <!--end::Page Scripts -->
            </body>
    <!-- end::Body -->

</html>
