<?php 
include('../include/security.php');
include('../include/conn.php');
?>
<!DOCTYPE html>
<html lang="en" >
<head>
        <meta charset="utf-8"/>

        <title><?php echo $title;?> - Countries</title>
        <meta name="description" content="Countries">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <!--begin::Fonts -->
        <link rel="stylesheet" href="assets/css/bear/fonts.css?family=Poppins:300,400,500,600,700|Roboto:300,400,500,600,700">       <!--end::Fonts -->

        
        
        <!--begin::Global Theme Styles(used by all pages) -->
                    <link href="assets/vendors/global/vendors.bundle.css" rel="stylesheet" type="text/css" />
                    <link href="assets/css/bear/style.bundle.css" rel="stylesheet" type="text/css" />
                <!--end::Global Theme Styles -->

        <!--begin::Layout Skins(used by all pages) -->
                <!--end::Layout Skins -->

        <link rel="shortcut icon" href="assets/media/logos/favicon.png" />

    </head>
    <!-- end::Head -->

    <!-- begin::Body -->
    <body  class="kt-app__aside--left kt-quick-panel--right kt-demo-panel--right kt-offcanvas-panel--right kt-header--fixed kt-header-mobile--fixed kt-subheader--enabled kt-subheader--transparent kt-aside--enabled kt-aside--fixed kt-aside--minimize kt-page--loading"  >

       
    	<!-- begin:: Page -->
	
<!-- begin:: Header Mobile -->
<?php include("../include/header-mobile.php");?>	
<!-- end:: Header Mobile -->
	<div class="kt-grid kt-grid--hor kt-grid--root">
		<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--ver kt-page">
			<!-- begin:: Aside -->
<button class="kt-aside-close " id="kt_aside_close_btn"><i class="la la-close"></i></button>

<?php include("../include/leftside-menu.php");?>	
<div class="kt-aside-menu-overlay"></div>
<!-- end:: Aside --></div>

<div class="kt-aside-menu-overlay"></div>
<!-- end:: Aside -->
			<div class="kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor kt-wrapper" id="kt_wrapper">
<!-- begin:: Header -->
<div id="kt_header" class="kt-header kt-grid kt-grid--ver  kt-header--fixed " >
			<!-- begin: Header Menu -->
<button class="kt-header-menu-wrapper-close" id="kt_header_menu_mobile_close_btn"><i class="la la-close"></i></button>
<?php include("../include/header-top-menu.php");?>	
<!-- end: Header Menu -->	
	<!-- begin:: Header Topbar -->
<div class="kt-header__topbar">
	<!--begin: Search -->
	<div class="kt-header__topbar-item kt-header__topbar-item--search">
		<div class="kt-header__topbar-wrapper">
			<div class="kt-quick-search kt-quick-search--inline kt-quick-search--result-compact" id="kt_quick_search_inline">
    <form method="get" class="kt-quick-search__form">
        <div class="input-group">
            <div class="input-group-prepend"><span class="input-group-text"><i class="flaticon2-search-1"></i></span></div>
            <input type="text" class="form-control kt-quick-search__input" placeholder="Search...">
            <div class="input-group-append"><span class="input-group-text"><i class="la la-close kt-quick-search__close" style="display: none;"></i></span></div>
        </div>
    </form>
    <div id="kt_quick_search_toggle" data-toggle="dropdown" data-offset="0px,10px"></div>
    <div class="dropdown-menu dropdown-menu-fit dropdown-menu-right dropdown-menu-anim dropdown-menu-lg">
        <div class="kt-quick-search__wrapper kt-scroll" data-scroll="true" data-height="300" data-mobile-height="200">

        </div>
    </div>
</div>
		</div>
	</div>
	<!--end: Search -->

	<!--begin: Notifications -->
	<?php include("../include/header-notifications.php");?>	
	<!--end: Notifications -->

	<!--begin: Quick actions -->
    <?php include("../include/header-top-right-quick-btn.php");?>
	<!--end: Quick actions -->



	<!--begin: User bar -->
	<?php include("../include/header-top-right.php");?>
	<!--end: User bar -->


</div>
<!-- end:: Header Topbar -->
</div>
<!-- end:: Header -->
				<div class="kt-content  kt-grid__item kt-grid__item--fluid kt-grid kt-grid--hor" id="kt_content">
											
<!-- begin:: Subheader -->
<div class="kt-subheader   kt-grid__item" id="kt_subheader">
    <div class="kt-container  kt-container--fluid ">
        <div class="kt-subheader__main">
            <h3 class="kt-subheader__title">
					                <button class="kt-subheader__mobile-toggle kt-subheader__mobile-toggle--left" id="kt_subheader_mobile_toggle"><span></span></button>
	            
                Categories                          </h3>

                            <span class="kt-subheader__separator kt-hidden"></span>
                <div class="kt-subheader__breadcrumbs">
  

                                            <span class="kt-subheader__breadcrumbs-separator"></span>
                        <a href="javascript:" class="kt-subheader__breadcrumbs-link">
                            Add Country                        </a>
                                        <!-- <span class="kt-subheader__breadcrumbs-link kt-subheader__breadcrumbs-link--active">Active link</span> -->
                </div>
                    </div>
      
	  
	
	</div>
</div>
<!-- end:: Subheader -->
					
					<!-- begin:: Content -->
	<div class="kt-container  kt-container--fluid  kt-grid__item kt-grid__item--fluid">
		<!--Begin::App-->
<div class="kt-grid kt-grid--desktop kt-grid--ver kt-grid--ver-desktop kt-app">
    <!--Begin:: App Aside Mobile Toggle-->
    <button class="kt-app__aside-close" id="kt_user_profile_aside_close">
        <i class="la la-close"></i>
    </button>
    <!--End:: App Aside Mobile Toggle-->

    <!--Begin:: App Aside-->
    <div class="kt-grid__item kt-app__toggle kt-app__aside" id="kt_user_profile_aside">
        <!--begin:: Widgets/Applications/User/Profile1-->
<div class="kt-portlet kt-portlet--height-fluid-">
    <div class="kt-portlet__head  kt-portlet__head--noborder">
        <div class="kt-portlet__head-label">
            <h3 class="kt-portlet__head-title">
            </h3>
        </div>
   
    </div>
    <div class="kt-portlet__body kt-portlet__body--fit-y">
        <!--begin::Widget -->
        <div class="kt-widget kt-widget--user-profile-1">
     
            <div class="kt-widget__body">
               <form class="kt-form" id="kt_form" action="../controllers/countries.php?insert=<?php echo base64_encode('country');?>" method="POST" enctype="multipart/form-data">               
			   <div class="kt-widget__content">
					<div class="row">		
					 <div class="col-lg-12"> 								
						<div class="form-group">
							<label>Full Name</label>
							<input type="text" class="form-control" id="country_name" name="country_name" required>
							<span class="form-text text-muted">Please enter your country full name.</span>
						</div>
					 </div>	

					  <div class="col-lg-12"> 								
						<div class="form-group">
							<label>Short Name</label>
							<input type="text" class="form-control" id="country_short_name" name="country_short_name" required>
							<span class="form-text text-muted">Please enter your country short name.</span>
						</div>
					 </div>	

					 <div class="col-lg-12"> 								
						<div class="form-group">
							<button class="btn btn-success btn-md btn-tall btn-wide kt-font-bold kt-font-transform-u" data-ktwizard-type="action-submit">
							Submit
						</button>
						</div>
					 </div>	
					 
					</div>
                </div>
               </form>
			 
		   </div>
        </div>
        <!--end::Widget -->
    </div>

	
	
	</div>
<!--end:: Widgets/Applications/User/Profile1-->

     </div>
    <!--End:: App Aside-->

    <!--Begin:: App Content-->
    <div class="kt-grid__item kt-grid__item--fluid kt-app__content">
        <div class="row">
            <div class="col-xl-12">
                <!--begin:: Widgets/Order Statistics-->
<div class="kt-portlet kt-portlet--height-fluid">
	<div class="kt-portlet__head">
		<div class="kt-portlet__head-label">
			<h3 class="kt-portlet__head-title">
				Recent Countries
			</h3>
		</div>
		<div class="kt-portlet__head-toolbar">
  
		</div>
	</div>
	<div class="kt-portlet__body kt-portlet__body--fluid">
		<div class="kt-widget12">
			<div class="kt-widget12__content">
		<!--begin: Datatable -->
		<table class="kt-datatable" id="html_table" width="100%">
			<thead>
			<tr>
			    <th>Full Name</th>
				<th>Short Name</th>
				<th>Status</th>
                <th>Action</th>
			</tr>
			</thead>
			<tbody>
			<?php 
			   $countries= mysqli_query($db,"SELECT * FROM tblcountries order by country_id desc limit 0,50");
			   while($country = mysqli_fetch_array($countries)){  	
		    ?>
				<tr>
                <td><?php echo $country['country_name'];?></td>
                <td><?php echo $country['country_short_name'];?></td>
				<td>
				<?php if($country['country_status']=='Active'){?>
				<span class="kt-font-bold kt-font-success"><?php echo $country['country_status'];?></span>
				<?php }elseif($country['country_status']=='Inactive'){?>
				<span class="kt-font-bold kt-font-danger"><?php echo $country['country_status'];?></span>
				<?php } ?>
				</td>
				<td>
				        <a href="javascript:;" class="btn btn-sm btn-clean btn-icon btn-icon-md" title="Edit">
							<i class="la la-edit"></i></a>
							
						<a href="javascript:;" class="btn btn-sm btn-clean btn-icon btn-icon-md" title="Delete">
							<i class="la la-trash"></i></a>
				</td>
			</tr>
			
			<?php } ?>	
			
			</tbody>
		
		
		
		</table>
		<!--end: Datatable -->  
			</div>
			
		</div>	
            <div class="kt-widget12__chart" style="height:765px;">
				
			</div>		
	</div>
</div>
<!--end:: Widgets/Order Statistics-->            </div>
 
        </div>   
      
	  
	
	</div>
    <!--End:: App Content-->
</div>
<!--End::App-->
	</div>
<!-- end:: Content -->				</div>	
				
				<!-- begin:: Footer -->
<?php include("../include/footer.php");?>
<!-- end:: Footer -->			</div>
		</div>
	</div>
	
<!-- end:: Page -->

<?php include("../include/footer-quick-modal.php");?>
    
    <!-- begin::Scrolltop -->
<div id="kt_scrolltop" class="kt-scrolltop">
		<i class="fa fa-arrow-up"></i>
</div>
<!-- end::Scrolltop -->




						 </div>
                        </div>
                    </div>
             
                </div>
            </div>
        </div>
    </div>
</div>
<!--ENd:: Chat-->
        <!-- begin::Global Config(global config for global JS sciprts) -->
        <script>
            var KTAppOptions = {"colors":{"state":{"brand":"#22b9ff","light":"#ffffff","dark":"#282a3c","primary":"#5867dd","success":"#34bfa3","info":"#36a3f7","warning":"#ffb822","danger":"#fd3995"},"base":{"label":["#c5cbe3","#a1a8c3","#3d4465","#3e4466"],"shape":["#f0f3ff","#d9dffa","#afb4d4","#646c9a"]}}};
        </script>
        <!-- end::Global Config -->

    	<!--begin::Global Theme Bundle(used by all pages) -->
    	    	   <script src="assets/vendors/global/vendors.bundle.js" type="text/javascript"></script>
		    	   <script src="assets/js/bear/scripts.bundle.js" type="text/javascript"></script>
				<!--end::Global Theme Bundle -->

        
                    <!--begin::Page Scripts(used by this page) -->
                            <script src="assets/js/bear/pages/dashboard.js" type="text/javascript"></script>
							<script src="assets/js/bear/pages/custom/expense/profile.js" type="text/javascript"></script> 
							<script src="assets/js/bear/pages/html-table.js" type="text/javascript"></script> 
						    <script src="assets/js/bear/pages/input-mask.js" type="text/javascript"></script>
							<script src="../assets/js/bear/pages/widgets/bootstrap-datepicker.js" type="text/javascript"></script>
                        <!--end::Page Scripts -->
            </body>
    <!-- end::Body -->

</html>
